/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cache.lock;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.cache.lock.CacheParam;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Configuration
public class CacheLockInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CacheLockInterceptor.class);
    private static final String CACHE_LOCK_PREFIX = ":cache:lock:";
    private static final String CACHE_LOCK_VALUE = "locked";
    @Value(value="${spring.application.name:dap}")
    private String appName;

    private static HttpServletRequest getCurrentRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(requestAttributes -> requestAttributes instanceof ServletRequestAttributes).map(requestAttributes -> (ServletRequestAttributes)requestAttributes).map(ServletRequestAttributes::getRequest).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.digiwin.dap.middle.cache.lock.CacheLock)")
    public Object interceptCacheLock(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        logger.debug("Starting locking: [{}]", (Object)methodSignature.toString());
        CacheLock cacheLock = methodSignature.getMethod().getAnnotation(CacheLock.class);
        String cacheLockKey = this.buildCacheLockKey(cacheLock, joinPoint);
        logger.debug("Built lock key: [{}]", (Object)cacheLockKey);
        try {
            boolean cacheResult = RedisUtils.setIfAbsent(cacheLockKey, CACHE_LOCK_VALUE, cacheLock.expired(), cacheLock.timeUnit());
            if (!cacheResult) {
                throw new BusinessException((ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS);
            }
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            if (cacheLock.autoDelete()) {
                RedisUtils.delete(cacheLockKey);
                logger.debug("Deleted the cache lock: [{}]", (Object)cacheLock);
            }
        }
    }

    private String buildCacheLockKey(@NonNull CacheLock cacheLock, @NonNull ProceedingJoinPoint joinPoint) {
        Assert.notNull((Object)cacheLock, (String)"Cache lock must not be null");
        Assert.notNull((Object)joinPoint, (String)"Proceeding join point must not be null");
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        StringBuilder cacheKeyBuilder = new StringBuilder(this.appName + CACHE_LOCK_PREFIX);
        String delimiter = cacheLock.delimiter();
        if (StringUtils.hasText((String)cacheLock.prefix())) {
            cacheKeyBuilder.append(cacheLock.prefix());
        } else {
            cacheKeyBuilder.append(methodSignature.getMethod().toString());
        }
        Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            logger.debug("Parameter annotation[{}] = {}", (Object)i, (Object)parameterAnnotations[i]);
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                Annotation annotation = parameterAnnotations[i][j];
                logger.debug("Parameter annotation[{}][{}]: {}", new Object[]{i, j, annotation});
                if (!(annotation instanceof CacheParam)) continue;
                Object arg = joinPoint.getArgs()[i];
                logger.debug("Cache param args: [{}]", arg);
                cacheKeyBuilder.append(delimiter).append(arg.toString());
            }
        }
        return cacheKeyBuilder.toString();
    }
}

