redis.replicate_commands()

-- KEYS: list of keys for the token buckets
-- ARGV[1]: the capacity of the token bucket (max tokens)
-- ARGV[2]: the number of tokens to add per second (token refill rate)
-- ARGV[3]: the number of tokens needed for a request

local capacity = tonumber(ARGV[1])
local refillRate = tonumber(ARGV[2])
local tokensRequired = tonumber(ARGV[3])

-- 获取当前的UNIX时间戳(单位:秒)
local now = redis.call('TIME')[1]

-- 计算令牌桶填充的周期,以此周期作为过期时间(单位:秒)
local ttl = math.ceil(capacity / refillRate)

for i = 1 , #KEYS do

    local key = KEYS[i]

    -- 当前的令牌桶信息(令牌数量、上一次填充令牌的时间)
    local bucket = redis.call('HMGET', key, 'tokens', 'last_refill')
    local tokens = tonumber(bucket[1]) or capacity
    local lastRefill = tonumber(bucket[2]) or now

    -- 计算上一次填充令牌的时间(单位:秒),以此计算出需要填充的令牌数
    local elapsedTime = now - lastRefill
    local tokensToAdd = math.floor(elapsedTime * refillRate)
    tokens = math.min(capacity, tokens + tokensToAdd)

    -- 如果当前令牌小于需要令牌则放行，否则放弃请求
    if tokens >= tokensRequired then
        -- 扣减令牌
        tokens = tokens - tokensRequired
        redis.call('HMSET', key, 'tokens', tokens, 'last_refill', now)
        redis.call("EXPIRE", key, ttl)
    else
        return 0
    end
end

return 1
