redis.replicate_commands()

-- 获取传入的参数
local window_size = tonumber(ARGV[1]) -- 滑动窗口的时间范围（单位：秒）
local limit = tonumber(ARGV[2])      -- 滑动窗口内的最大请求次数
local now = redis.call('TIME')       -- 获取当前时间戳（秒和微秒）
local current_time = now[1] * 1000 + math.floor(now[2] / 1000) -- 将当前时间转为毫秒

-- 遍历每个键进行限流判断
for i = 1, #KEYS do

    local key = KEYS[i]

    -- 移除窗口外的旧请求
    redis.call('ZREMRANGEBYSCORE', key, 0, current_time - window_size * 1000)

    -- 获取窗口内的请求数
    local count = redis.call('ZCARD', key)

    if count >= limit then
        -- 如果超过了限流阈值，则返回 0 表示限流
        return 0
    else
        -- 记录当前请求
        redis.call('ZADD', key, current_time, current_time)
        redis.call('EXPIRE', key, window_size) -- 设置过期时间，防止键一直存在
    end
end

-- 如果所有键都未超过限流阈值，则返回 1 表示允许通过
return 1
