/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cache.limiter.aspect;

import com.digiwin.dap.middle.cache.limiter.RateLimiterKeyGenerators;
import com.digiwin.dap.middle.cache.limiter.annotation.SlidingWindowRateLimiter;
import com.digiwin.dap.middle.cache.limiter.callback.AbstractRateLimiterCallback;
import com.digiwin.dap.middle.cache.limiter.callback.RateLimiterCallback;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.RequestNotPermittedException;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class SlidingWindowRateLimiterInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SlidingWindowRateLimiterInterceptor.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final RedisScript<Boolean> script;
    @Value(value="${spring.application.name:dap}")
    private String appName;
    @Value(value="${dap.middleware.rate.limiter:true}")
    private boolean rateLimiter;

    public SlidingWindowRateLimiterInterceptor(RedisTemplate<String, Object> redisTemplate, @Qualifier(value="slidingWindowRateLimiterScript") RedisScript<Boolean> script) {
        this.redisTemplate = redisTemplate;
        this.script = script;
    }

    @Before(value="(@annotation(com.digiwin.dap.middle.cache.limiter.annotation.SlidingWindowRateLimiter))")
    public void execute(JoinPoint joinPoint) {
        if (!this.rateLimiter) {
            return;
        }
        Boolean allowed = true;
        Class<? extends AbstractRateLimiterCallback> callbackClass = null;
        try {
            SlidingWindowRateLimiter slidingWindowRateLimiter = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(SlidingWindowRateLimiter.class);
            long windowSize = slidingWindowRateLimiter.windowSize();
            int maxRequests = slidingWindowRateLimiter.maxRequests();
            callbackClass = slidingWindowRateLimiter.callback();
            List<String> keyList = RateLimiterKeyGenerators.generateRateLimiterKey(joinPoint.getArgs(), joinPoint.getTarget(), joinPoint.getSignature(), slidingWindowRateLimiter.param(), slidingWindowRateLimiter.dimensions(), slidingWindowRateLimiter.operator());
            if (CollectionUtils.isEmpty(keyList)) {
                throw new RequestNotPermittedException((ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS);
            }
            keyList = keyList.stream().map(element -> this.appName + ":" + "sliding:window:" + element).collect(Collectors.toList());
            allowed = (Boolean)this.redisTemplate.execute(this.script, keyList, new Object[]{windowSize, maxRequests});
        }
        catch (Exception e) {
            logger.error("Error determining if user allowed from redis", (Throwable)e);
        }
        if (allowed == null || !allowed.booleanValue()) {
            RateLimiterCallback rateLimiterCallback = null;
            try {
                rateLimiterCallback = (RateLimiterCallback)callbackClass.newInstance();
            }
            catch (Exception e) {
                logger.error("rate limited callback error", (Throwable)e);
            }
            if (rateLimiterCallback != null) {
                rateLimiterCallback.onRateLimited();
            } else {
                throw new RequestNotPermittedException((ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS);
            }
        }
    }
}

