/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cache;

import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisUtils {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtils.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    private static final long DEFAULT_LOCK_TIME = 120L;
    private static final long REDIS_SCAN_COUNT = 50000L;
    private static final String REDIS_ERROR = "\u3010Redis\u5f02\u5e38\u3011";
    private static RedisTemplate<String, Object> redisTemplate;

    public static void initTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisUtils.redisTemplate = redisTemplate;
    }

    public static RedisTemplate<String, Object> getRedisTemplate() {
        return redisTemplate;
    }

    public static ValueOperations<String, Object> opsForValue() {
        return redisTemplate.opsForValue();
    }

    public static HashOperations<String, Object, Object> opsForHash() {
        return redisTemplate.opsForHash();
    }

    public static ListOperations<String, Object> opsForList() {
        return redisTemplate.opsForList();
    }

    public static SetOperations<String, Object> opsForSet() {
        return redisTemplate.opsForSet();
    }

    public static ZSetOperations<String, Object> opsForZSet() {
        return redisTemplate.opsForZSet();
    }

    public static void set(String key, Object value) {
        try {
            String json = objectMapper.writeValueAsString(value);
            redisTemplate.opsForValue().set((Object)key, (Object)json);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
    }

    public static void set(String key, Object value, Duration duration) {
        try {
            String json = objectMapper.writeValueAsString(value);
            redisTemplate.opsForValue().set((Object)key, (Object)json, duration);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
    }

    public static void delete(String key) {
        try {
            redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
    }

    public static Long delete(Collection<String> keys) {
        try {
            return redisTemplate.delete(keys);
        }
        catch (Exception e) {
            logger.error("\u3010Redis\u5f02\u5e38\u3011Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", keys, (Object)e.getMessage());
            return 0L;
        }
    }

    public static <T> T get(Object key, Class<T> type) {
        try {
            Object obj = redisTemplate.opsForValue().get(key);
            if (obj != null) {
                return (T)objectMapper.readValue(obj.toString(), type);
            }
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
        return null;
    }

    public static <T> T get(Object key, TypeReference<T> valueTypeRef) {
        try {
            Object obj = redisTemplate.opsForValue().get(key);
            if (obj != null) {
                return (T)objectMapper.readValue(obj.toString(), valueTypeRef);
            }
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
        return null;
    }

    public static Set<String> keys(String pattern) {
        try {
            return RedisUtils.scan(pattern);
        }
        catch (Exception e) {
            logger.error("\u3010Redis\u5f02\u5e38\u3011Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)pattern, (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Set<String> scan(String pattern) {
        return (Set)redisTemplate.execute(connection -> {
            HashSet<String> result = new HashSet<String>();
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().match(pattern).count(50000L).build());){
                while (cursor.hasNext()) {
                    result.add(new String((byte[])cursor.next(), StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                logger.error("\u3010Redis\u5f02\u5e38\u3011Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)pattern, (Object)e.getMessage());
            }
            return result;
        });
    }

    public static boolean hasKey(String key) {
        try {
            Boolean result = redisTemplate.hasKey((Object)key);
            return Objects.equals(result, Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
            return false;
        }
    }

    public static void expire(String key, long timeout, TimeUnit unit) {
        try {
            redisTemplate.expire((Object)key, timeout, unit);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
    }

    public static Long getExpire(String key) {
        try {
            return redisTemplate.getExpire((Object)key);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
            return null;
        }
    }

    public static Long getExpire(String key, TimeUnit timeUnit) {
        try {
            return redisTemplate.getExpire((Object)key, timeUnit);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
            return null;
        }
    }

    public static boolean lock(String key, String value) {
        try {
            Boolean result = redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, 120L, TimeUnit.SECONDS);
            return Objects.equals(result, Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
            return false;
        }
    }

    public static void unlock(String key) {
        try {
            redisTemplate.opsForValue().getOperations().delete((Object)key);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
        }
    }

    public static boolean setIfAbsent(String key, Object value, Duration timeout) {
        try {
            Boolean absent = redisTemplate.opsForValue().setIfAbsent((Object)key, value, timeout);
            return Objects.equals(absent, Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
            return false;
        }
    }

    public static boolean setIfAbsent(String key, Object value, long timeout, TimeUnit unit) {
        try {
            Boolean absent = redisTemplate.opsForValue().setIfAbsent((Object)key, value, timeout, unit);
            return Objects.equals(absent, Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{REDIS_ERROR, key, e.getMessage()});
            return false;
        }
    }

    public static void changeDb(int num) {
        RedisStandaloneConfiguration standaloneConfig;
        JedisConnectionFactory jedisConnectionFactory = (JedisConnectionFactory)redisTemplate.getConnectionFactory();
        if (jedisConnectionFactory != null && jedisConnectionFactory.getDatabase() != num && (standaloneConfig = jedisConnectionFactory.getStandaloneConfiguration()) != null) {
            standaloneConfig.setDatabase(num);
            redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        }
    }
}

