/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cache;

import com.digiwin.dap.middleware.util.SnowFlake;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
class SnowflakeManager {
    private static final Logger logger = LoggerFactory.getLogger(SnowflakeManager.class);
    @Value(value="${spring.application.name:dap}")
    private String appName;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    SnowflakeManager() {
    }

    @PostConstruct
    public void init() {
        String cacheKey = this.appName + ":snowflake:machineid";
        Long increment = this.stringRedisTemplate.opsForValue().increment((Object)cacheKey);
        long machineId = increment == null ? 0L : increment & 7L;
        SnowFlake.getInstance().init(machineId);
        logger.info("SnowFlake.init snowflake machine id is {}", (Object)machineId);
    }

    public Long getId() {
        return SnowFlake.getInstance().newId();
    }
}

