package com.digiwin.dap.middle.database.encrypt.desensitization.processor;

import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.enums.DatabaseEncryptExceptionEnum;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationConvertEnum;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middle.database.encrypt.model.SensitiveWordProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DesensitizationProcessorFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizationProcessorFactory.class);

    private final DesensitizationProcessorRegistry desensitizationProcessorRegistry;

    private final Map<String, SensitiveWordProperty> objectDesensitizationProperty;

    private final Object object;

    private final DesensitizationConvertEnum desensitizationConvertEnum;

    public DesensitizationProcessorFactory(DesensitizationProcessorRegistry desensitizationProcessorRegistry, Map<String, SensitiveWordProperty> objectDesensitizationProperty, Object object, DesensitizationConvertEnum desensitizationConvertEnum) {
        this.desensitizationProcessorRegistry = desensitizationProcessorRegistry;
        this.objectDesensitizationProperty = objectDesensitizationProperty;
        this.object = object;
        this.desensitizationConvertEnum = desensitizationConvertEnum;
    }

    public Object process() {
        return process(this.object);
    }

    private Object process(Object o) throws DatabaseEncryptException {
        if (o instanceof Optional) {
            Optional<?> optional = (Optional) o;
            o = optional.map(this::process).orElse(null);
        } else if (o instanceof List) {
            List<?> list = (List) o;
            for (Object item : list)
                process(item);
        } else if (o instanceof Map) {
            Map<String, Object> paramMap = (Map<String, Object>) o;
            StringBuffer errorMessage = new StringBuffer();
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                if (this.objectDesensitizationProperty.containsKey(entry.getKey()))
                    try {
                        SensitiveWordProperty sensitiveWordProperty = this.objectDesensitizationProperty.get(entry.getKey());
                        DesensitizationProcessor desensitizationProcessor = this.desensitizationProcessorRegistry.findDesensitizationProcessor(sensitiveWordProperty.getDesensitizationModeEnum());
                        String newValue = Objects.equals(this.desensitizationConvertEnum, DesensitizationConvertEnum.DESENSITIZATION) ? desensitizationProcessor.desensitize(entry.getKey(), (String) entry.getValue()) : desensitizationProcessor.revert(entry.getKey(), (String) entry.getValue());
                        entry.setValue(newValue);
                    } catch (Exception e) {
                        errorMessage.append(e.getMessage());
                    }
            }
            if (errorMessage.length() > 0)
                throw new DatabaseEncryptException(errorMessage.toString());
        } else if (o instanceof String) {
            if (this.objectDesensitizationProperty.size() == 1) {
                Map.Entry<String, SensitiveWordProperty> entry = this.objectDesensitizationProperty.entrySet().iterator().next();
                DesensitizationProcessor desensitizationProcessor = this.desensitizationProcessorRegistry.findDesensitizationProcessor(((SensitiveWordProperty) entry.getValue()).getDesensitizationModeEnum());
                o = Objects.equals(this.desensitizationConvertEnum, DesensitizationConvertEnum.DESENSITIZATION) ? desensitizationProcessor.desensitize(entry.getKey(), (String) o) : desensitizationProcessor.revert(entry.getKey(), (String) o);
            } else {
                throw new DatabaseEncryptException(DatabaseEncryptExceptionEnum.FOUND_MULTIPLE_SENSITIVE_WORD_PROPERTY);
            }
        } else {
            StringBuffer errorMessage = new StringBuffer();
            Field[] fields = o.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                if (this.objectDesensitizationProperty.containsKey(field.getName())) {
                    SensitiveWordProperty sensitiveWordProperty = this.objectDesensitizationProperty.get(field.getName());
                    DesensitizationProcessor desensitizationProcessor = this.desensitizationProcessorRegistry.findDesensitizationProcessor(sensitiveWordProperty.getDesensitizationModeEnum());
                    try {
                        String oldValue = (String) field.get(o);
                        String newValue = Objects.equals(this.desensitizationConvertEnum, DesensitizationConvertEnum.DESENSITIZATION) ? desensitizationProcessor.desensitize(field.getName(), oldValue) : desensitizationProcessor.revert(field.getName(), oldValue);
                        field.set(o, newValue);
                    } catch (Exception e) {
                        errorMessage.append(e.getMessage());
                    }
                }
            }
            if (errorMessage.length() > 0)
                throw new DatabaseEncryptException(errorMessage.toString());
        }
        return o;
    }
}
