/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.sql.parser.impl;

import com.digiwin.dap.middle.database.encrypt.enums.DatabaseEncryptExceptionEnum;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middle.database.encrypt.model.ObjectRelationalMapping;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.update.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="sqlParser")
public class CCJSqlParserImpl
implements SqlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CCJSqlParserImpl.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    private static final String MYSQL_DIALECT = "`";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @PostConstruct
    public void clearCache() {
        if (this.redisTemplate.hasKey((Object)"dap:database:encrypt:sql:parse").booleanValue()) {
            this.redisTemplate.delete((Object)"dap:database:encrypt:sql:parse");
        }
    }

    @Override
    public List<ObjectRelationalMapping> parseQuerySql(String id, String sql) {
        List<ObjectRelationalMapping> objectRelationalMappings = new ArrayList<ObjectRelationalMapping>();
        try {
            if (this.redisTemplate.opsForHash().hasKey((Object)"dap:database:encrypt:sql:parse", (Object)id).booleanValue()) {
                Object cache = this.redisTemplate.opsForHash().get((Object)"dap:database:encrypt:sql:parse", (Object)id);
                objectRelationalMappings = (List)objectMapper.readValue(cache.toString(), (TypeReference)new TypeReference<List<ObjectRelationalMapping>>(){});
                return objectRelationalMappings;
            }
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                LOGGER.debug("====>sql\u89e3\u6790,\u6682\u4e0d\u652f\u6301\u89e3\u6790\u975eselect\u8bed\u53e5");
                return objectRelationalMappings;
            }
            List<TableInfo> tableInfoList = CCJSqlParserImpl.parseTableFromStatement(statement);
            objectRelationalMappings = CCJSqlParserImpl.parseResultSetFromStatement((Select)statement, tableInfoList);
            this.redisTemplate.opsForHash().put((Object)"dap:database:encrypt:sql:parse", (Object)id, (Object)objectMapper.writeValueAsString(objectRelationalMappings));
        }
        catch (Exception e) {
            if (e instanceof JSQLParserException) {
                LOGGER.error("====>\u89e3\u6790sql\u5f02\u5e38:\u3010{}\u3011", (Object)sql);
            }
            LOGGER.error("====>\u89e3\u6790sql\u83b7\u53d6\u7ed3\u679c\u5217\u5f02\u5e38,\u5f02\u5e38sql:\u3010{}\u3011", (Object)sql);
            throw new DatabaseEncryptException(DatabaseEncryptExceptionEnum.PARSE_SQL, sql);
        }
        return objectRelationalMappings;
    }

    private static List<ObjectRelationalMapping> parseResultSetFromStatement(Select select, final List<TableInfo> tableInfoList) {
        final ArrayList<ObjectRelationalMapping> objectRelationalMappings = new ArrayList<ObjectRelationalMapping>();
        SelectBody selectBody = select.getSelectBody();
        selectBody.accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                List selectItems = plainSelect.getSelectItems();
                for (SelectItem selectItem : selectItems) {
                    if (!(selectItem instanceof SelectExpressionItem)) continue;
                    SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
                    Expression expression = expressionItem.getExpression();
                    if (expression instanceof Function) {
                        LOGGER.debug("====>\u51fd\u6570\u7ed3\u679c\u5217\u3010{}\u3011\u6682\u4e0d\u652f\u6301\u89e3\u6790", (Object)expression);
                        continue;
                    }
                    if (expression instanceof CaseExpression) {
                        LOGGER.debug("====>case\u7ed3\u679c\u5217\u3010{}\u3011\u6682\u4e0d\u652f\u6301\u89e3\u6790", (Object)expression);
                        continue;
                    }
                    if (expression instanceof Column) {
                        String expressionString = expression.toString();
                        String aliasTableName = expressionString.contains(".") ? expressionString.substring(0, expressionString.indexOf(".")) : "";
                        String columnName = expressionString.contains(".") ? expressionString.substring(expressionString.indexOf(".") + 1) : expressionString;
                        String aliasColumnName = expressionItem.getAlias() != null ? expressionItem.getAlias().getName() : columnName;
                        String tableName = StringUtils.hasLength((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : ((TableInfo)tableInfoList.get(0)).getTableName().toLowerCase();
                        columnName = columnName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        aliasColumnName = aliasColumnName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        objectRelationalMappings.add(new ObjectRelationalMapping(tableName, columnName, aliasColumnName));
                        LOGGER.debug("====>\u6570\u636e\u5e93\u3010{}\u3011\u8868,\u5b57\u6bb5\u3010{}\u3011,\u6620\u5c04\u5230\u5bf9\u8c61\u4e2d\u5c5e\u6027\u540d\u4e3a\u3010{}\u3011", new Object[]{tableName, columnName, aliasColumnName});
                        continue;
                    }
                    LOGGER.debug("====>\u672a\u77e5\u7ed3\u679c\u5217\u3010{}\u3011\u6682\u4e0d\u652f\u6301\u89e3\u6790", (Object)expression);
                }
            }
        });
        return objectRelationalMappings;
    }

    private static List<TableInfo> parseTableFromStatement(Statement statement) {
        final ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        if (statement instanceof Select) {
            Select selectStatement = (Select)statement;
            SelectBody selectBody = selectStatement.getSelectBody();
            selectBody.accept((SelectVisitor)new SelectVisitorAdapter(){

                public void visit(PlainSelect plainSelect) {
                    FromItem fromItem = plainSelect.getFromItem();
                    if (fromItem instanceof Table) {
                        Table table = (Table)fromItem;
                        String tableName = table.getName();
                        String[] parts = tableName.split("\\s+");
                        tableName = parts[0];
                        tableName = tableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        String aliasTableName = table.getAlias() != null ? table.getAlias().getName() : tableName;
                        aliasTableName = aliasTableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        tableInfoList.add(new TableInfo(tableName, aliasTableName));
                    }
                    if (plainSelect.getJoins() != null) {
                        for (Join join : plainSelect.getJoins()) {
                            FromItem joinItem = join.getRightItem();
                            if (!(joinItem instanceof Table)) continue;
                            Table table = (Table)joinItem;
                            String tableName = table.getName();
                            String[] parts = tableName.split("\\s+");
                            tableName = parts[0];
                            tableName = tableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                            String aliasTableName = table.getAlias() != null ? table.getAlias().getName() : tableName;
                            aliasTableName = aliasTableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                            tableInfoList.add(new TableInfo(tableName, aliasTableName));
                        }
                    }
                }
            });
        } else if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            Table table = updateStatement.getTable();
            tableInfoList.add(new TableInfo(table.getName(), table.getAlias().getName()));
            if (updateStatement.getJoins() != null) {
                for (Join join : updateStatement.getJoins()) {
                    FromItem fromItem = join.getRightItem();
                    if (!(fromItem instanceof Table)) continue;
                    Table table1 = (Table)fromItem;
                    tableInfoList.add(new TableInfo(table1.getName(), table1.getAlias().getName()));
                }
            }
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            List tableList = deleteStatement.getTables();
            for (Table table : tableList) {
                tableInfoList.add(new TableInfo(table.getName(), table.getAlias().getName()));
            }
            if (deleteStatement.getJoins() != null) {
                for (Join join : deleteStatement.getJoins()) {
                    FromItem fromItem = join.getRightItem();
                    if (!(fromItem instanceof Table)) continue;
                    Table table1 = (Table)fromItem;
                    tableInfoList.add(new TableInfo(table1.getName(), table1.getAlias().getName()));
                }
            }
        } else if (statement instanceof Insert) {
            Insert insertStatement = (Insert)statement;
            Table table = insertStatement.getTable();
            tableInfoList.add(new TableInfo(table.getName(), table.getAlias().getName()));
        }
        return tableInfoList;
    }

    static class TableInfo {
        private final String tableName;
        private final String aliasTableName;

        public TableInfo(String tableName, String aliasTableName) {
            this.tableName = tableName;
            this.aliasTableName = aliasTableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getAliasTableName() {
            return this.aliasTableName;
        }
    }
}

