package com.digiwin.dap.middle.database.encrypt.config;

import com.digiwin.dap.middle.database.encrypt.condition.DatabaseEncryptedStorageCondition;
import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.impl.DesensitizationConverterImpl;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.register.DefaultSensitiveWordDatabaseRegistry;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.register.SensitiveWordDatabaseRegistry;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middle.database.encrypt.sql.parser.impl.CCJSqlParserImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * @author michael
 */
@Configuration
@Conditional(DatabaseEncryptedStorageCondition.class)
public class DatabaseEncryptConfig {

    @Autowired
    private Environment environment;

    @Autowired
    @Qualifier("desensitizationProcessorRegistry")
    private DesensitizationProcessorRegistry desensitizationProcessorRegistry;

    @Bean("sensitiveWordDatabase")
    public SensitiveWordDatabaseRegistry sensitiveWordDatabaseRegistry() {
        return new DefaultSensitiveWordDatabaseRegistry(environment);
    }

    @Bean("desensitizationConverter")
    public DesensitizationConverter desensitizationConverter(){
        return new DesensitizationConverterImpl(sensitiveWordDatabaseRegistry(),desensitizationProcessorRegistry);
    }

    @Bean("sqlParser")
    public SqlParser sqlParser() {
        return new CCJSqlParserImpl();
    }
}
