package com.digiwin.dap.middle.database.encrypt.desensitization.processor;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author michael
 */
@DesensitizationStrategy(mode = DesensitizationModeEnum.AES)
public class AESDesensitizationProcessor implements DesensitizationProcessor {

    private final static Logger LOGGER = LoggerFactory.getLogger(AESDesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        try {
            // 如果当前值可以解密,说明已经是密文不需要再进行加密
            AES.decryptHex(value, KeyConstant.DIGIWIN);
            LOGGER.info("===>{}字段已经AES加密,密文:{}", field, value);
            return value;
        } catch (Exception e) {
            try {
                return AES.encryptHex(value, KeyConstant.DIGIWIN);
            } catch (Exception e2) {
                // 加密失败返回原文
                LOGGER.error("===>{}字段已经AES加密异常,值:{}", field, value);
                return value;
            }
        }
    }

    @Override
    public String revert(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        try {
            return AES.decryptHex(value, KeyConstant.DIGIWIN);
        } catch (Exception e) {
            // 解密失败返回原文
            LOGGER.error("===>{}字段已经AES解密异常,值:{}", field, value);
            return value;
        }
    }
}
