package com.digiwin.dap.middle.database.encrypt.annotation;

import com.digiwin.dap.middle.database.encrypt.desensitization.checker.Checker;
import com.digiwin.dap.middle.database.encrypt.desensitization.checker.DefaultAbstractChecker;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;

import java.lang.annotation.*;

/**
 * 标识数据库表敏感字段
 *
 * @author michael
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface SensitiveField {


    /**
     * 脱敏方式
     *
     * @return com.digiwin.dap.middleware.database.enums.DesensitizationMode
     **/
    DesensitizationModeEnum mode() default DesensitizationModeEnum.AES;

    /**
     * 脱敏前置校验
     *
     * @return java.lang.Class<? extends com.digiwin.dap.middle.database.encrypt.desensitization.checker.Checker>
     **/
    Class<? extends Checker> checker() default DefaultAbstractChecker.class;
}

