package com.digiwin.dap.middle.database.encrypt.annotation;

import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;

import java.lang.annotation.*;

/**
 * 标识数据库表敏感字段
 *
 * @author michael
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface SensitiveField {


    /**
     * 脱敏方式
     *
     * @return com.digiwin.dap.middleware.database.enums.DesensitizationMode
     * @author michael
     * @date 2024/6/5 09:41
     **/
    DesensitizationMode desensitizationMode() default DesensitizationMode.MYSQL_AES;

    /**
     * 数据库列名
     *
     * @return java.lang.String
     * @author michael
     * @date 2024/6/6 10:57
     **/
    String columnName();
}

