package com.digiwin.dap.middle.database.encrypt.processor.desensitization;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.kms.service.KmsService;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middleware.util.SpringBeansUtils;
import com.digiwin.dap.middleware.util.StringUtils;

/**
 * @author michael
 * @version 1.0.0
 * @see
 */
@DesensitizationStrategy(desensitizationMode = DesensitizationMode.MYSQL_AES)
public class MySQLAESDesensitizationProcessor implements DesensitizationProcessor {

    @Override
    public String desensitize(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        // 如果不是16进制字符串进行加密
        if (!StringUtils.isHexadecimal(value)) {
            KmsService kmsService = SpringBeansUtils.getBean(KmsService.class);
            return AES.encryptHex(value, kmsService.findKey(KeyConstant.DIGIWIN));
        }
        return value;
    }

    @Override
    public String revert(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        // 如果是16进制字符串进行解密
        if (StringUtils.isHexadecimal(value)) {
            KmsService kmsService = SpringBeansUtils.getBean(KmsService.class);
            return AES.decryptHex(value, kmsService.findKey(KeyConstant.DIGIWIN));
        }
        return value;
    }

}
