/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.processor.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.database.encrypt.processor.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.kms.service.KmsService;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.util.SpringBeansUtils;
import com.digiwin.dap.middleware.util.StringUtils;

@DesensitizationStrategy(desensitizationMode=DesensitizationMode.MYSQL_AES)
public class MySQLAESDesensitizationProcessor
implements DesensitizationProcessor {
    @Override
    public String desensitize(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (!StringUtils.isHexadecimal((String)value)) {
            KmsService kmsService = (KmsService)SpringBeansUtils.getBean(KmsService.class);
            return AES.encryptHex((String)value, (String)kmsService.findKey("digiwin_aes_key.pem"));
        }
        return value;
    }

    @Override
    public String revert(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (StringUtils.isHexadecimal((String)value)) {
            KmsService kmsService = (KmsService)SpringBeansUtils.getBean(KmsService.class);
            return AES.decryptHex((String)value, (String)kmsService.findKey("digiwin_aes_key.pem"));
        }
        return value;
    }
}

