/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.registry.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.database.encrypt.processor.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.registry.desensitization.DesensitizationProcessorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultDesensitizationProcessorRegistry
implements DesensitizationProcessorRegistry,
BeanFactoryPostProcessor {
    private Map<String, DesensitizationProcessor> desensitizationProcessorMap = new ConcurrentHashMap<String, DesensitizationProcessor>();

    @Override
    public DesensitizationProcessor findDesensitizationProcessor(DesensitizationMode desensitizationMode) {
        if (!this.desensitizationProcessorMap.containsKey(desensitizationMode.name())) {
            throw new RuntimeException("No desensitization processor found for " + desensitizationMode.name());
        }
        return this.desensitizationProcessorMap.get(desensitizationMode.name());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanNamesForAnnotation(DesensitizationStrategy.class)) {
            Object bean = beanFactory.getBean(beanName);
            if (!(bean instanceof DesensitizationProcessor)) continue;
            DesensitizationStrategy desensitizationStrategy = (DesensitizationStrategy)AnnotatedElementUtils.findMergedAnnotation(bean.getClass(), DesensitizationStrategy.class);
            DesensitizationMode desensitizationMode = desensitizationStrategy.desensitizationMode();
            this.desensitizationProcessorMap.put(desensitizationMode.name(), (DesensitizationProcessor)bean);
        }
    }
}

