/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.utils;

import com.digiwin.dap.middle.database.encrypt.model.ParameterMappingRelation;
import com.digiwin.dap.middle.database.encrypt.model.ResultSetMappingRelation;
import com.digiwin.dap.middle.database.encrypt.model.SqlParseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SqlParserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlParserUtils.class);

    public static void main(String[] args) {
        String[] sqlStatements;
        for (String sqlStatement : sqlStatements = new String[]{"UPDATE table_name AS t SET t.column1 = 'new_value', t.column2 = 'another_value' WHERE t.column3 = 'value'", "UPDATE table_name SET column1 = 'new_value' WHERE column2 = 'value2'"}) {
            SqlParserUtils.parseSql(sqlStatement);
        }
    }

    public static SqlParseResult parseSql(String sql) {
        SqlParseResult sqlParseResult = new SqlParseResult();
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            List<TableInfo> tableInfoList = SqlParserUtils.parseTableFromStatement(statement);
            List<ParameterMappingRelation> whereConditionInfos = SqlParserUtils.parseWhereFromStatement(statement, tableInfoList);
            List<ResultSetMappingRelation> resultSetInfos = statement instanceof Select ? SqlParserUtils.parseResultSetFromStatement((Select)statement, tableInfoList) : null;
            List<ParameterMappingRelation> operationColumnInfos = statement instanceof Update || statement instanceof Insert ? SqlParserUtils.parseOperationColumnFromStatement(statement, tableInfoList) : null;
            sqlParseResult.setResultSetInfos(resultSetInfos);
            sqlParseResult.setOperationColumnInfos(operationColumnInfos);
            sqlParseResult.setWhereConditionInfos(whereConditionInfos);
        }
        catch (Exception e) {
            LOGGER.error("SQL\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return sqlParseResult;
    }

    private static List<ResultSetMappingRelation> parseResultSetFromStatement(Select select, final List<TableInfo> tableInfoList) {
        final ArrayList<ResultSetMappingRelation> resultSetMappingRelations = new ArrayList<ResultSetMappingRelation>();
        SelectBody selectBody = select.getSelectBody();
        selectBody.accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                List selectItems = plainSelect.getSelectItems();
                for (SelectItem selectItem : selectItems) {
                    SelectExpressionItem expressionItem;
                    if (!(selectItem instanceof SelectExpressionItem) || (expressionItem = (SelectExpressionItem)selectItem).getExpression() instanceof Function) continue;
                    String expressionString = expressionItem.getExpression().toString();
                    String aliasTableName = expressionString.contains(".") ? expressionString.substring(0, expressionString.indexOf(".")) : "";
                    String columnName = expressionString.contains(".") ? expressionString.substring(expressionString.indexOf(".") + 1) : expressionString;
                    String aliasColumnName = expressionItem.getAlias() != null ? expressionItem.getAlias().getName() : columnName;
                    String tableName = StringUtils.hasLength((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : ((TableInfo)tableInfoList.get(0)).getTableName().toLowerCase();
                    resultSetMappingRelations.add(new ResultSetMappingRelation(tableName, columnName, aliasColumnName));
                    LOGGER.info("===>\u6570\u636e\u5e93\u3010{}\u3011\u8868,\u5b57\u6bb5\u3010{}\u3011,\u6620\u5c04\u5230\u5bf9\u8c61\u4e2d\u5c5e\u6027\u540d\u4e3a\u3010{}\u3011", new Object[]{tableName, columnName, aliasColumnName});
                }
            }
        });
        return resultSetMappingRelations;
    }

    private static List<ParameterMappingRelation> parseWhereFromStatement(Statement statement, final List<TableInfo> tableInfoList) {
        final ArrayList<ParameterMappingRelation> whereConditionMappingRelations = new ArrayList<ParameterMappingRelation>();
        Expression whereExpression = null;
        if (statement instanceof Select) {
            Select select = (Select)statement;
            SelectBody selectBody = select.getSelectBody();
            if (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                whereExpression = plainSelect.getWhere();
            }
        } else if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            whereExpression = updateStatement.getWhere();
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            deleteStatement.getTables();
            whereExpression = deleteStatement.getWhere();
        } else if (statement instanceof Insert) {
            Insert insertStatement = (Insert)statement;
            insertStatement.getTable();
        }
        if (whereExpression != null) {
            whereExpression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                protected void visitBinaryExpression(BinaryExpression expr) {
                    String tableName;
                    String realColumnName;
                    String aliasTableName;
                    String columnName;
                    Column column;
                    if (expr.getLeftExpression() instanceof Column) {
                        column = (Column)expr.getLeftExpression();
                        columnName = column.getColumnName();
                        aliasTableName = columnName.contains(".") ? columnName.substring(0, columnName.indexOf(".")) : "";
                        realColumnName = columnName.contains(".") ? columnName.substring(columnName.indexOf(".") + 1) : columnName;
                        tableName = StringUtils.hasLength((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : ((TableInfo)tableInfoList.get(0)).getTableName().toLowerCase();
                        whereConditionMappingRelations.add(new ParameterMappingRelation(tableName, realColumnName));
                    }
                    if (expr.getRightExpression() instanceof Column) {
                        column = (Column)expr.getRightExpression();
                        columnName = column.getColumnName();
                        aliasTableName = columnName.contains(".") ? columnName.substring(0, columnName.indexOf(".")) : "";
                        realColumnName = columnName.contains(".") ? columnName.substring(columnName.indexOf(".") + 1) : columnName;
                        tableName = StringUtils.hasLength((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : ((TableInfo)tableInfoList.get(0)).getTableName().toLowerCase();
                        whereConditionMappingRelations.add(new ParameterMappingRelation(tableName, realColumnName));
                    }
                    super.visitBinaryExpression(expr);
                }
            });
        }
        return whereConditionMappingRelations;
    }

    private static List<ParameterMappingRelation> parseOperationColumnFromStatement(Statement statement, List<TableInfo> tableInfoList) {
        if (!(statement instanceof Update) && !(statement instanceof Insert)) {
            return Collections.emptyList();
        }
        ArrayList<ParameterMappingRelation> operationColumnMappingRelations = new ArrayList<ParameterMappingRelation>();
        if (statement instanceof Update) {
            Update update = (Update)statement;
            ArrayList updateSetList = update.getUpdateSets();
            for (UpdateSet updateSet : updateSetList) {
                for (Column column : updateSet.getColumns()) {
                    String columnName = column.getColumnName();
                    String aliasTableName = columnName.contains(".") ? columnName.substring(0, columnName.indexOf(".")) : "";
                    String realColumnName = columnName.contains(".") ? columnName.substring(columnName.indexOf(".") + 1) : columnName;
                    String tableName = StringUtils.hasLength((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : tableInfoList.get(0).getTableName().toLowerCase();
                    operationColumnMappingRelations.add(new ParameterMappingRelation(tableName, realColumnName));
                }
            }
        }
        if (statement instanceof Insert) {
            Insert insert = new Insert();
            for (Column column : insert.getColumns()) {
                String columnName = column.getColumnName();
                String aliasTableName = columnName.contains(".") ? columnName.substring(0, columnName.indexOf(".")) : "";
                String realColumnName = columnName.contains(".") ? columnName.substring(columnName.indexOf(".") + 1) : columnName;
                String tableName = StringUtils.hasLength((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : tableInfoList.get(0).getTableName().toLowerCase();
                operationColumnMappingRelations.add(new ParameterMappingRelation(tableName, realColumnName));
            }
        }
        return operationColumnMappingRelations;
    }

    private static List<TableInfo> parseTableFromStatement(Statement statement) {
        final ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        if (statement instanceof Select) {
            Select selectStatement = (Select)statement;
            SelectBody selectBody = selectStatement.getSelectBody();
            selectBody.accept((SelectVisitor)new SelectVisitorAdapter(){

                public void visit(PlainSelect plainSelect) {
                    FromItem fromItem = plainSelect.getFromItem();
                    if (fromItem instanceof Table) {
                        Table table = (Table)fromItem;
                        String tableName = table.getName();
                        String[] parts = tableName.split("\\s+");
                        tableName = parts[0];
                        String aliasTableName = table.getAlias() != null ? table.getAlias().getName() : null;
                        tableInfoList.add(new TableInfo(tableName, aliasTableName));
                    }
                    if (plainSelect.getJoins() != null) {
                        for (Join join : plainSelect.getJoins()) {
                            FromItem joinItem = join.getRightItem();
                            if (!(joinItem instanceof Table)) continue;
                            Table table = (Table)joinItem;
                            String tableName = table.getName();
                            String[] parts = tableName.split("\\s+");
                            tableName = parts[0];
                            String aliasTableName = table.getAlias() != null ? table.getAlias().getName() : null;
                            tableInfoList.add(new TableInfo(tableName, aliasTableName));
                        }
                    }
                }
            });
        } else if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            Table table = updateStatement.getTable();
            tableInfoList.add(new TableInfo(table.getName(), table.getAlias().getName()));
            if (updateStatement.getJoins() != null) {
                for (Join join : updateStatement.getJoins()) {
                    FromItem fromItem = join.getRightItem();
                    if (!(fromItem instanceof Table)) continue;
                    Table table1 = (Table)fromItem;
                    tableInfoList.add(new TableInfo(table1.getName(), table1.getAlias().getName()));
                }
            }
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            List tableList = deleteStatement.getTables();
            for (Table table : tableList) {
                tableInfoList.add(new TableInfo(table.getName(), table.getAlias().getName()));
            }
            if (deleteStatement.getJoins() != null) {
                for (Join join : deleteStatement.getJoins()) {
                    FromItem fromItem = join.getRightItem();
                    if (!(fromItem instanceof Table)) continue;
                    Table table1 = (Table)fromItem;
                    tableInfoList.add(new TableInfo(table1.getName(), table1.getAlias().getName()));
                }
            }
        } else if (statement instanceof Insert) {
            Insert insertStatement = (Insert)statement;
            Table table = insertStatement.getTable();
            tableInfoList.add(new TableInfo(table.getName(), table.getAlias().getName()));
        }
        return tableInfoList;
    }

    static class TableInfo {
        private String tableName;
        private String aliasTableName;

        public TableInfo(String tableName, String aliasTableName) {
            this.tableName = tableName;
            this.aliasTableName = aliasTableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getAliasTableName() {
            return this.aliasTableName;
        }
    }
}

