package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author michael
 */
@DesensitizationStrategy(mode = DesensitizationMode.AES)
public class AESDesensitizationProcessor implements DesensitizationProcessor {

    private final static Logger LOGGER = LoggerFactory.getLogger(AESDesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            // todo 兼容 如果能够解密成功,说明已经加密不能重复加密 暂时不支持兼容
            // String s = AES.decryptHex(value, kmsService.findKey(KeyConstant.DIGIWIN));
            return AES.encryptHex(value,KeyConstant.DIGIWIN);
        } catch (Exception e) {
            LOGGER.error("===>字段【{}】aes加密脱敏异常", field, e);
        }
        return value;
    }

    @Override
    public String revert(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            return AES.decryptHex(value, KeyConstant.DIGIWIN);
        } catch (Exception e) {
            LOGGER.error("===>字段【{}】aes解密还原异常", field, e);
        }
        return value;
    }

}
