package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author michael
 */
@DesensitizationStrategy(mode = DesensitizationMode.SHA256)
public class SHA256DesensitizationProcessor implements DesensitizationProcessor {

    private final static Logger LOGGER = LoggerFactory.getLogger(SHA256DesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            return DigestUtils.sha256(value);
        } catch (Exception e) {
            LOGGER.error("===>字段【{}】sha256加密脱敏异常", field, e);
        }
        return value;
    }

    @Override
    public String revert(String field, String value) {
        return value;
    }
}
