/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.desensitization.DefaultDesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DesensitizationProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizationProcessorFactory.class);
    private DefaultDesensitizationProcessorRegistry desensitizationProcessorRegistry;

    @Autowired
    public DesensitizationProcessorFactory(@Autowired DefaultDesensitizationProcessorRegistry desensitizationProcessorRegistry) {
        this.desensitizationProcessorRegistry = desensitizationProcessorRegistry;
    }

    public Object revert(String fieldName, Object result, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) {
        try {
            if (fieldAndDesensitizationModeMap == null || fieldAndDesensitizationModeMap.isEmpty() || result == null) {
                LOGGER.warn("===>\u654f\u611f\u8bcd\u5e93\u6216\u8005\u7ed3\u679c\u96c6\u4e3a\u7a7a,\u4e0d\u9700\u8981\u8fdb\u884c\u8fd8\u539f");
                return result;
            }
            if (result instanceof List) {
                for (Object o : (List)result) {
                    this.revertObject(fieldName, o, fieldAndDesensitizationModeMap);
                }
            } else {
                this.revertObject(fieldName, result, fieldAndDesensitizationModeMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("revert error", (Throwable)e);
        }
        return result;
    }

    public Object desensitize(String fieldName, Object parameter, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) {
        try {
            if (fieldAndDesensitizationModeMap == null || fieldAndDesensitizationModeMap.isEmpty() || parameter == null) {
                LOGGER.warn("===>\u654f\u611f\u8bcd\u5e93\u6216\u8005\u53c2\u6570\u4e3a\u7a7a,\u4e0d\u9700\u8981\u8fdb\u884c\u52a0\u5bc6");
                return parameter;
            }
            if (parameter instanceof List) {
                for (Object o : (List)parameter) {
                    this.desensitizeObject(fieldName, o, fieldAndDesensitizationModeMap);
                }
            } else {
                this.desensitizeObject(fieldName, parameter, fieldAndDesensitizationModeMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("desensitization error", (Throwable)e);
        }
        return parameter;
    }

    private Object desensitizeObject(String fieldName, Object o, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) throws IllegalAccessException {
        if (o instanceof String) {
            if (fieldAndDesensitizationModeMap.containsKey(fieldName)) {
                DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(fieldName));
                desensitizationProcessor.desensitize(fieldName, (String)o);
            }
        } else {
            Field[] fields;
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!fieldAndDesensitizationModeMap.containsKey(field.getName())) continue;
                DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(field.getName()));
                field.set(o, desensitizationProcessor.desensitize(field.getName(), (String)field.get(o)));
            }
        }
        return o;
    }

    private Object revertObject(String fieldName, Object o, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) throws IllegalAccessException {
        block5: {
            block4: {
                if (!(o instanceof String)) break block4;
                if (!fieldAndDesensitizationModeMap.containsKey(fieldName)) break block5;
                DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(fieldName));
                desensitizationProcessor.revert(fieldName, (String)o);
                break block5;
            }
            if (o instanceof Map) {
                Map paramMap = (Map)o;
                for (Map.Entry entry : paramMap.entrySet()) {
                    if (!fieldAndDesensitizationModeMap.containsKey(entry.getKey())) continue;
                    DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(entry.getKey()));
                    entry.setValue(desensitizationProcessor.revert((String)entry.getKey(), (String)entry.getValue()));
                }
            } else {
                Field[] fields;
                for (Field field : fields = o.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!fieldAndDesensitizationModeMap.containsKey(field.getName())) continue;
                    DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(field.getName()));
                    field.set(o, desensitizationProcessor.revert(field.getName(), (String)field.get(o)));
                }
            }
        }
        return o;
    }

    private DesensitizationProcessor getDesensitizationProcessor(DesensitizationMode mode) {
        return this.desensitizationProcessorRegistry.findDesensitizationProcessor(mode);
    }
}

