/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DesensitizationStrategy(mode=DesensitizationMode.SHA256)
public class SHA256DesensitizationProcessor
implements DesensitizationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SHA256DesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            return DigestUtils.sha256((String)value);
        }
        catch (Exception e) {
            LOGGER.error("===>\u5b57\u6bb5\u3010{}\u3011sha256\u52a0\u5bc6\u8131\u654f\u5f02\u5e38", (Object)field, (Object)e);
            return value;
        }
    }

    @Override
    public String revert(String field, String value) {
        return value;
    }
}

