/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DesensitizationStrategy(mode=DesensitizationMode.AES)
public class AESDesensitizationProcessor
implements DesensitizationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESDesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            return AES.encryptHex((String)value, (String)KeyConstant.DIGIWIN);
        }
        catch (Exception e) {
            LOGGER.error("===>\u5b57\u6bb5\u3010{}\u3011aes\u52a0\u5bc6\u8131\u654f\u5f02\u5e38", (Object)field, (Object)e);
            return value;
        }
    }

    @Override
    public String revert(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            return AES.decryptHex((String)value, (String)KeyConstant.DIGIWIN);
        }
        catch (Exception e) {
            LOGGER.error("===>\u5b57\u6bb5\u3010{}\u3011aes\u89e3\u5bc6\u8fd8\u539f\u5f02\u5e38", (Object)field, (Object)e);
            return value;
        }
    }
}

