package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author michael
 */
@DesensitizationStrategy(mode = DesensitizationMode.AES)
public class AESDesensitizationProcessor implements DesensitizationProcessor {

    private final static Logger LOGGER = LoggerFactory.getLogger(AESDesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            try {
                AES.decryptHex(value, KeyConstant.DIGIWIN);
            } catch (Exception e) {
                LOGGER.debug("===>对属性【{}】进行加密", field);
                return AES.encryptHex(value, KeyConstant.DIGIWIN);
            }
            LOGGER.debug("属性【{}】已经加密", field);
        } catch (Exception e) {
            // 抛出异常避免明文数据入库
            throw new DatabaseEncryptException("字段:" + field + ",值:" + value + " aes加密脱敏异常");
        }
        return value;
    }

    @Override
    public String revert(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            LOGGER.debug("===>对属性【{}】进行还原", field);
            return AES.decryptHex(value, KeyConstant.DIGIWIN);
        } catch (Exception e) {
            throw new DatabaseEncryptException("字段:" + field + ",值:" + value + " aes解密异常");
        }
    }
}
