package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author michael
 */
@DesensitizationStrategy(mode = DesensitizationMode.SHA256)
public class SHA256DesensitizationProcessor implements DesensitizationProcessor {

    private final static Logger LOGGER = LoggerFactory.getLogger(SHA256DesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            if (isValidDoubleSHA256(value)) {
                LOGGER.debug("属性【{}】已经加密", field);
                return value;
            }
            return DigestUtils.sha256(value);
        } catch (Exception e) {
            // 抛出异常避免明文数据入库
            throw new DatabaseEncryptException("字段:" + field + "值:" + value + " sha256加密异常");
        }
    }

    @Override
    public String revert(String field, String value) {
        return value;
    }

    private boolean isValidDoubleSHA256(String s) {
        if (s == null || s.length() != 64) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (!isHexCharacter(c)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isHexCharacter(char c) {
        return (c >= '0' && c <= '9') ||
                (c >= 'a' && c <= 'f') ||
                (c >= 'A' && c <= 'F');
    }
}
