/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.desensitization.DefaultDesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DesensitizationProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizationProcessorFactory.class);
    private final DefaultDesensitizationProcessorRegistry desensitizationProcessorRegistry;

    @Autowired
    public DesensitizationProcessorFactory(@Autowired DefaultDesensitizationProcessorRegistry desensitizationProcessorRegistry) {
        this.desensitizationProcessorRegistry = desensitizationProcessorRegistry;
    }

    public Object revert(String fieldName, Object result, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) {
        try {
            if (fieldAndDesensitizationModeMap == null || fieldAndDesensitizationModeMap.isEmpty() || result == null) {
                return result;
            }
            if (result instanceof Optional) {
                Optional optional = (Optional)result;
                Object optionalValue = optional.orElse(null);
                if (optionalValue != null) {
                    Object newResult = this.revertObject(fieldName, optionalValue, fieldAndDesensitizationModeMap);
                    result = Optional.ofNullable(newResult);
                }
            } else if (result instanceof List) {
                ArrayList<Object> newResult = new ArrayList<Object>();
                for (Object o : (List)result) {
                    newResult.add(this.revertObject(fieldName, o, fieldAndDesensitizationModeMap));
                }
                result = newResult;
            } else {
                result = this.revertObject(fieldName, result, fieldAndDesensitizationModeMap);
            }
        }
        catch (Exception e) {
            throw new DatabaseEncryptException(e);
        }
        return result;
    }

    public Object desensitize(String fieldName, Object parameter, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) {
        try {
            if (fieldAndDesensitizationModeMap == null || fieldAndDesensitizationModeMap.isEmpty() || parameter == null) {
                return parameter;
            }
            if (parameter instanceof Optional) {
                Optional optional = (Optional)parameter;
                Object optionalValue = optional.orElse(null);
                if (optionalValue != null) {
                    Object newParameter = this.desensitizeObject(fieldName, optionalValue, fieldAndDesensitizationModeMap);
                    parameter = Optional.ofNullable(newParameter);
                }
            } else if (parameter instanceof List) {
                ArrayList<Object> newParameter = new ArrayList<Object>();
                for (Object o : (List)parameter) {
                    newParameter.add(this.desensitizeObject(fieldName, o, fieldAndDesensitizationModeMap));
                }
                parameter = newParameter;
            } else {
                parameter = this.desensitizeObject(fieldName, parameter, fieldAndDesensitizationModeMap);
            }
        }
        catch (Exception e) {
            throw new DatabaseEncryptException(e);
        }
        return parameter;
    }

    private Object desensitizeObject(String fieldName, Object o, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) {
        if (o instanceof String) {
            if (fieldAndDesensitizationModeMap.containsKey(fieldName)) {
                DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(fieldName));
                o = desensitizationProcessor.desensitize(fieldName, (String)o);
            }
        } else {
            Field[] fields;
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!fieldAndDesensitizationModeMap.containsKey(field.getName())) continue;
                DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(field.getName()));
                try {
                    String oldValue = (String)field.get(o);
                    String newValue = desensitizationProcessor.desensitize(field.getName(), oldValue);
                    field.set(o, newValue);
                }
                catch (Exception e) {
                    if (e instanceof DatabaseEncryptException) {
                        LOGGER.error("===>\u5bf9\u8c61\u3010{}\u3011\u5b57\u6bb5\u3010{}\u3011\u52a0\u5bc6\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u3010{}\u3011", new Object[]{o.getClass().getName(), field.getName(), e.getMessage()});
                    }
                    if (!(e instanceof IllegalAccessException)) continue;
                    LOGGER.error("===>\u5bf9\u8c61\u3010{}\u3011\u5b57\u6bb5\u3010{}\u3011\u52a0\u5bc6\u65f6\u65e0\u6cd5\u83b7\u53d6\u6216\u8005\u8bbe\u7f6e\u503c", (Object)o.getClass().getName(), (Object)field.getName());
                }
            }
        }
        return o;
    }

    private Object revertObject(String fieldName, Object o, Map<String, DesensitizationMode> fieldAndDesensitizationModeMap) {
        try {
            if (o instanceof String) {
                if (fieldAndDesensitizationModeMap.containsKey(fieldName)) {
                    DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(fieldName));
                    o = desensitizationProcessor.revert(fieldName, (String)o);
                }
            } else if (o instanceof Map) {
                Map paramMap = (Map)o;
                for (Map.Entry entry : paramMap.entrySet()) {
                    if (!fieldAndDesensitizationModeMap.containsKey(entry.getKey())) continue;
                    DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(entry.getKey()));
                    entry.setValue(desensitizationProcessor.revert((String)entry.getKey(), (String)entry.getValue()));
                }
            } else {
                Field[] fields;
                for (Field field : fields = o.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!fieldAndDesensitizationModeMap.containsKey(field.getName())) continue;
                    DesensitizationProcessor desensitizationProcessor = this.getDesensitizationProcessor(fieldAndDesensitizationModeMap.get(field.getName()));
                    try {
                        String oldValue = (String)field.get(o);
                        String newValue = desensitizationProcessor.revert(field.getName(), oldValue);
                        field.set(o, newValue);
                    }
                    catch (Exception e) {
                        if (e instanceof DatabaseEncryptException) {
                            LOGGER.error("===>\u5bf9\u8c61\u3010{}\u3011\u5b57\u6bb5\u3010{}\u3011\u89e3\u5bc6\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u3010{}\u3011", new Object[]{o.getClass().getName(), field.getName(), e.getMessage()});
                        }
                        if (!(e instanceof IllegalAccessException)) continue;
                        LOGGER.error("===>\u5bf9\u8c61\u3010{}\u3011\u5b57\u6bb5\u3010{}\u3011\u89e3\u5bc6\u65f6\u65e0\u6cd5\u83b7\u53d6\u6216\u8005\u8bbe\u7f6e\u503c", (Object)o.getClass().getName(), (Object)field.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("===>\u6570\u636e\u5e93\u52a0\u89e3\u5bc6,\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
        }
        return o;
    }

    private DesensitizationProcessor getDesensitizationProcessor(DesensitizationMode mode) {
        return this.desensitizationProcessorRegistry.findDesensitizationProcessor(mode);
    }
}

