/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DesensitizationStrategy(mode=DesensitizationMode.SHA256)
public class SHA256DesensitizationProcessor
implements DesensitizationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SHA256DesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        try {
            if (value == null || value.isEmpty()) {
                return value;
            }
            if (this.isValidDoubleSHA256(value)) {
                LOGGER.debug("\u5c5e\u6027\u3010{}\u3011\u5df2\u7ecf\u52a0\u5bc6", (Object)field);
                return value;
            }
            return DigestUtils.sha256((String)value);
        }
        catch (Exception e) {
            throw new DatabaseEncryptException("\u5b57\u6bb5:" + field + "\u503c:" + value + " sha256\u52a0\u5bc6\u5f02\u5e38");
        }
    }

    @Override
    public String revert(String field, String value) {
        return value;
    }

    private boolean isValidDoubleSHA256(String s) {
        if (s == null || s.length() != 64) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (SHA256DesensitizationProcessor.isHexCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

