/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.sensitive.word;

import com.digiwin.dap.middle.database.encrypt.annotation.Desensitization;
import com.digiwin.dap.middle.database.encrypt.annotation.SensitiveField;
import com.digiwin.dap.middle.database.encrypt.model.SensitiveWordDatabase;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.SensitiveWordDatabaseRegistry;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DefaultSensitiveWordDatabaseRegistry
implements SensitiveWordDatabaseRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSensitiveWordDatabaseRegistry.class);
    private Environment environment;
    private Map<String, List<SensitiveWordDatabase>> sensitiveWordDatabaseMap = new ConcurrentHashMap<String, List<SensitiveWordDatabase>>();

    public DefaultSensitiveWordDatabaseRegistry(Environment environment) {
        this.environment = environment;
    }

    @Override
    public List<SensitiveWordDatabase> findSensitiveWordDatabase(String tableName) {
        return this.sensitiveWordDatabaseMap.get(tableName);
    }

    @PostConstruct
    public void run() {
        LOGGER.info("------\u521d\u59cb\u5316\u6570\u636e\u5e93\u654f\u611f\u8bcd\u5e93------");
        String packageName = this.environment.getProperty("mybatis.typeAliasesPackage");
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set entityClasses = reflections.getTypesAnnotatedWith(Entity.class);
        if (Objects.isNull(entityClasses) || entityClasses.isEmpty()) {
            LOGGER.error("===>\u626b\u63cf\u3010{}\u3011\u672a\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b.", (Object)packageName);
        }
        for (Class entityClass : entityClasses) {
            Field[] fields;
            if (!entityClass.isAnnotationPresent(Desensitization.class) || !entityClass.isAnnotationPresent(Table.class)) continue;
            Table table = entityClass.getAnnotation(Table.class);
            String tableName = table.name();
            Desensitization desensitization = entityClass.getAnnotation(Desensitization.class);
            if (!desensitization.enabled()) {
                LOGGER.warn("\u3010{}\u3011\u6807\u6ce8\u654f\u611f\u5b57\u6bb5,\u4f46\u662f\u672a\u5f00\u542f\u8131\u654f!", (Object)entityClass.getName());
                continue;
            }
            for (Field field : fields = entityClass.getDeclaredFields()) {
                field.setAccessible(true);
                SensitiveField sensitiveField = field.getAnnotation(SensitiveField.class);
                if (Objects.isNull(sensitiveField)) continue;
                LOGGER.info("===>\u6570\u636e\u5e93\u8868\u3010{}\u3011\u5b57\u6bb5\u3010{}\u3011\u4e3a\u654f\u611f\u5b57\u6bb5,\u5b9e\u4f53\u5c5e\u6027\u540d\u4e3a\u3010{}\u3011.", new Object[]{tableName, sensitiveField.columnName(), field.getName()});
                SensitiveWordDatabase sensitiveWordDatabase = new SensitiveWordDatabase(tableName.toLowerCase(), sensitiveField.columnName(), field.getName(), sensitiveField.mode());
                if (!this.sensitiveWordDatabaseMap.containsKey(tableName)) {
                    this.sensitiveWordDatabaseMap.put(tableName, new CopyOnWriteArrayList());
                }
                this.sensitiveWordDatabaseMap.get(tableName).add(sensitiveWordDatabase);
            }
        }
        LOGGER.info("------\u6570\u636e\u5e93\u654f\u611f\u8bcd\u5e93\u521d\u59cb\u5316\u5b8c\u6210------");
    }
}

