/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization.service.impl;

import com.digiwin.dap.middle.database.encrypt.desensitization.context.DesensitizationConvertContext;
import com.digiwin.dap.middle.database.encrypt.desensitization.processor.DesensitizationProcessorFactory;
import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.enums.DatabaseEncryptExceptionEnum;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationConvertEnum;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middle.database.encrypt.model.ObjectRelationalMapping;
import com.digiwin.dap.middle.database.encrypt.model.SensitiveWordProperty;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.context.SensitiveWordContext;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.register.SensitiveWordDatabaseRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DesensitizationConverterImpl<C>
implements DesensitizationConverter<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizationConverterImpl.class);
    private final SensitiveWordDatabaseRegistry sensitiveWordDatabaseRegistry;
    private final DesensitizationProcessorRegistry desensitizationProcessorRegistry;

    public DesensitizationConverterImpl(SensitiveWordDatabaseRegistry sensitiveWordDatabaseRegistry, DesensitizationProcessorRegistry desensitizationProcessorRegistry) {
        this.sensitiveWordDatabaseRegistry = sensitiveWordDatabaseRegistry;
        this.desensitizationProcessorRegistry = desensitizationProcessorRegistry;
    }

    @Override
    public Object desensitize(DesensitizationConvertContext<C> context) {
        if (Objects.isNull(context.getContext())) {
            LOGGER.debug("===>{}()\u53c2\u6570\u4e3a\u7a7a\u4e0d\u9700\u8981\u8fdb\u884c\u8131\u654f\u5904\u7406.", (Object)context.getTargetMethod());
            return context.getContext();
        }
        Map<String, SensitiveWordProperty> sensitiveWordPropertyMap = this.getSensitiveWordPropertyMap(context);
        if (sensitiveWordPropertyMap.isEmpty()) {
            LOGGER.debug("===>{}()\u53c2\u6570\u4e0d\u6d89\u53ca\u654f\u611f\u5b57\u6bb5\u4e0d\u9700\u8981\u8fdb\u884c\u8131\u654f\u5904\u7406.", (Object)context.getTargetMethod());
            return context.getContext();
        }
        DesensitizationProcessorFactory desensitizationProcessorFactory = new DesensitizationProcessorFactory(this.desensitizationProcessorRegistry, sensitiveWordPropertyMap, context.getContext(), DesensitizationConvertEnum.DESENSITIZATION);
        try {
            LOGGER.info("===>{}()\u5bf9\u53c2\u6570\u4e2d{}\u5c5e\u6027\u8fdb\u884c\u8131\u654f", (Object)context.getTargetMethod(), (Object)String.join((CharSequence)", ", sensitiveWordPropertyMap.keySet()));
            return desensitizationProcessorFactory.process();
        }
        catch (Exception e) {
            throw new DatabaseEncryptException(DatabaseEncryptExceptionEnum.DESENSITIZATION_FAIL, context.getTargetMethod());
        }
    }

    @Override
    public Object revert(DesensitizationConvertContext<C> context) {
        if (Objects.isNull(context.getContext())) {
            LOGGER.debug("===>{}()\u8fd4\u56de\u4e3a\u7a7a\u4e0d\u9700\u8981\u8fdb\u884c\u8fd8\u539f\u5904\u7406.", (Object)context.getTargetMethod());
            return context.getContext();
        }
        Map<String, SensitiveWordProperty> sensitiveWordPropertyMap = this.getSensitiveWordPropertyMap(context);
        if (sensitiveWordPropertyMap.isEmpty()) {
            LOGGER.debug("===>{}()\u8fd4\u56de\u4e0d\u6d89\u53ca\u654f\u611f\u5b57\u6bb5\u4e0d\u9700\u8981\u8fdb\u884c\u8fd8\u539f\u5904\u7406.", (Object)context.getTargetMethod());
            return context.getContext();
        }
        DesensitizationProcessorFactory desensitizationProcessorFactory = new DesensitizationProcessorFactory(this.desensitizationProcessorRegistry, sensitiveWordPropertyMap, context.getContext(), DesensitizationConvertEnum.REVERT);
        try {
            LOGGER.info("===>{}()\u5bf9\u8fd4\u56de\u7ed3\u679c\u4e2d{}\u5c5e\u6027\u8fdb\u884c\u8fd8\u539f", (Object)context.getTargetMethod(), (Object)String.join((CharSequence)", ", sensitiveWordPropertyMap.keySet()));
            return desensitizationProcessorFactory.process();
        }
        catch (Exception e) {
            throw new DatabaseEncryptException(DatabaseEncryptExceptionEnum.REVERT_FAIL, context.getTargetMethod());
        }
    }

    private Map<String, SensitiveWordProperty> getSensitiveWordPropertyMap(DesensitizationConvertContext<C> context) {
        HashMap<String, SensitiveWordProperty> sensitiveWordPropertyMap = new HashMap<String, SensitiveWordProperty>(16);
        List<ObjectRelationalMapping> mappings = context.getObjectRelationalMappings();
        if (!CollectionUtils.isEmpty(mappings)) {
            for (Map.Entry<String, List<ObjectRelationalMapping>> entry : mappings.stream().collect(Collectors.groupingBy(ObjectRelationalMapping::getTableName)).entrySet()) {
                String tableName = entry.getKey();
                SensitiveWordContext<Object> sensitiveWordContext = this.sensitiveWordDatabaseRegistry.findSensitiveWord(tableName);
                if (Objects.isNull(sensitiveWordContext) || CollectionUtils.isEmpty(sensitiveWordContext.getSensitiveWordPropertyList())) continue;
                for (ObjectRelationalMapping mapping : entry.getValue()) {
                    for (SensitiveWordProperty sensitiveWordProperty : sensitiveWordContext.getSensitiveWordPropertyList()) {
                        if (!Objects.equals(sensitiveWordProperty.getDataBaseColumnName(), mapping.getDatabaseColumnName())) continue;
                        sensitiveWordPropertyMap.put(mapping.getObjectPropertyName(), sensitiveWordProperty);
                    }
                }
            }
        }
        return sensitiveWordPropertyMap;
    }
}

