/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.sensitive.word.register;

import com.digiwin.dap.middle.database.encrypt.annotation.Desensitization;
import com.digiwin.dap.middle.database.encrypt.annotation.SensitiveField;
import com.digiwin.dap.middle.database.encrypt.model.SensitiveWordProperty;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.context.SensitiveWordContext;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.register.SensitiveWordDatabaseRegistry;
import com.digiwin.dap.middle.database.encrypt.utils.CamelToSnakeUtils;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class DefaultSensitiveWordDatabaseRegistry
implements SensitiveWordDatabaseRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSensitiveWordDatabaseRegistry.class);
    private final Environment environment;
    private final Map<String, SensitiveWordContext<Object>> sensitiveWordContextMap = new ConcurrentHashMap<String, SensitiveWordContext<Object>>();

    public DefaultSensitiveWordDatabaseRegistry(Environment environment) {
        this.environment = environment;
    }

    @Override
    public SensitiveWordContext<Object> findSensitiveWord(String tableName) {
        if (this.sensitiveWordContextMap.containsKey(tableName)) {
            return this.sensitiveWordContextMap.get(tableName);
        }
        return null;
    }

    @PostConstruct
    public void run() {
        LOGGER.info("===>\u521d\u59cb\u5316\u6570\u636e\u5e93\u654f\u611f\u8bcd\u5e93");
        String packageName = this.environment.getProperty("mybatis.typeAliasesPackage");
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set entityClasses = reflections.getTypesAnnotatedWith(Entity.class);
        if (Objects.isNull(entityClasses) || entityClasses.isEmpty()) {
            LOGGER.error("===>\u626b\u63cf\u3010{}\u3011\u672a\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b.", (Object)packageName);
        }
        for (Class entityClass : entityClasses) {
            Field[] fields;
            if (!entityClass.isAnnotationPresent(Desensitization.class) || !entityClass.isAnnotationPresent(Table.class)) continue;
            Table table = entityClass.getAnnotation(Table.class);
            String tableName = table.name();
            Desensitization desensitization = entityClass.getAnnotation(Desensitization.class);
            if (!desensitization.enabled()) {
                LOGGER.warn("===>\u3010{}\u3011\u6807\u6ce8\u654f\u611f\u5b57\u6bb5,\u4f46\u662f\u672a\u5f00\u542f\u8131\u654f!", (Object)entityClass.getName());
                continue;
            }
            for (Field field : fields = entityClass.getDeclaredFields()) {
                field.setAccessible(true);
                SensitiveField sensitiveField = field.getAnnotation(SensitiveField.class);
                if (Objects.isNull(sensitiveField)) continue;
                String entityPropertyName = field.getName();
                Column column = field.getAnnotation(Column.class);
                String dataBaseColumnName = column != null && StringUtils.hasLength((String)column.name()) ? column.name() : CamelToSnakeUtils.convertCamelToSnake(entityPropertyName);
                LOGGER.info("===>\u6570\u636e\u5e93\u8868\u3010{}\u3011\u5b57\u6bb5\u3010{}\u3011\u4e3a\u654f\u611f\u5b57\u6bb5,\u5c5e\u6027\u540d\u4e3a\u3010{}\u3011", new Object[]{tableName, dataBaseColumnName, field.getName()});
                SensitiveWordProperty sensitiveWordProperty = new SensitiveWordProperty(tableName.toLowerCase(), dataBaseColumnName, entityPropertyName, sensitiveField.mode(), sensitiveField.checker());
                if (!this.sensitiveWordContextMap.containsKey(tableName)) {
                    this.sensitiveWordContextMap.put(tableName, new SensitiveWordContext(tableName.toLowerCase(), new CopyOnWriteArrayList<SensitiveWordProperty>()));
                }
                this.sensitiveWordContextMap.get(tableName).getSensitiveWordPropertyList().add(sensitiveWordProperty);
            }
        }
        LOGGER.info("===>\u6570\u636e\u5e93\u654f\u611f\u8bcd\u5e93\u521d\u59cb\u5316\u5b8c\u6210");
    }
}

