/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization.processor;

import com.digiwin.dap.middle.database.encrypt.desensitization.processor.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.enums.DatabaseEncryptExceptionEnum;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationConvertEnum;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middle.database.encrypt.model.SensitiveWordProperty;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesensitizationProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizationProcessorFactory.class);
    private final DesensitizationProcessorRegistry desensitizationProcessorRegistry;
    private final Map<String, SensitiveWordProperty> objectDesensitizationProperty;
    private final Object object;
    private final DesensitizationConvertEnum desensitizationConvertEnum;

    public DesensitizationProcessorFactory(DesensitizationProcessorRegistry desensitizationProcessorRegistry, Map<String, SensitiveWordProperty> objectDesensitizationProperty, Object object, DesensitizationConvertEnum desensitizationConvertEnum) {
        this.desensitizationProcessorRegistry = desensitizationProcessorRegistry;
        this.objectDesensitizationProperty = objectDesensitizationProperty;
        this.object = object;
        this.desensitizationConvertEnum = desensitizationConvertEnum;
    }

    public Object process() {
        return this.process(this.object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object process(Object o) throws DatabaseEncryptException {
        Field[] fields;
        if (o instanceof Optional) {
            Optional optional = (Optional)o;
            return optional.map(this::process).orElse(null);
        }
        if (o instanceof List) {
            List list = (List)o;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                this.process(item);
            }
            return o;
        }
        if (o instanceof Map) {
            Map paramMap = (Map)o;
            StringBuffer errorMessage = new StringBuffer();
            for (Map.Entry entry : paramMap.entrySet()) {
                if (!this.objectDesensitizationProperty.containsKey(entry.getKey())) continue;
                try {
                    SensitiveWordProperty sensitiveWordProperty = this.objectDesensitizationProperty.get(entry.getKey());
                    DesensitizationProcessor desensitizationProcessor = this.desensitizationProcessorRegistry.findDesensitizationProcessor(sensitiveWordProperty.getDesensitizationModeEnum());
                    String newValue = Objects.equals((Object)this.desensitizationConvertEnum, (Object)DesensitizationConvertEnum.DESENSITIZATION) ? desensitizationProcessor.desensitize((String)entry.getKey(), (String)entry.getValue()) : desensitizationProcessor.revert((String)entry.getKey(), (String)entry.getValue());
                    entry.setValue(newValue);
                }
                catch (Exception e) {
                    errorMessage.append(e.getMessage());
                }
            }
            if (errorMessage.length() <= 0) return o;
            throw new DatabaseEncryptException(errorMessage.toString());
        }
        if (o instanceof String) {
            if (this.objectDesensitizationProperty.size() != 1) throw new DatabaseEncryptException(DatabaseEncryptExceptionEnum.FOUND_MULTIPLE_SENSITIVE_WORD_PROPERTY);
            Map.Entry<String, SensitiveWordProperty> entry = this.objectDesensitizationProperty.entrySet().iterator().next();
            DesensitizationProcessor desensitizationProcessor = this.desensitizationProcessorRegistry.findDesensitizationProcessor(entry.getValue().getDesensitizationModeEnum());
            return Objects.equals((Object)this.desensitizationConvertEnum, (Object)DesensitizationConvertEnum.DESENSITIZATION) ? desensitizationProcessor.desensitize(entry.getKey(), (String)o) : desensitizationProcessor.revert(entry.getKey(), (String)o);
        }
        StringBuffer errorMessage = new StringBuffer();
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!this.objectDesensitizationProperty.containsKey(field.getName())) continue;
            SensitiveWordProperty sensitiveWordProperty = this.objectDesensitizationProperty.get(field.getName());
            DesensitizationProcessor desensitizationProcessor = this.desensitizationProcessorRegistry.findDesensitizationProcessor(sensitiveWordProperty.getDesensitizationModeEnum());
            try {
                String oldValue = (String)field.get(o);
                String newValue = Objects.equals((Object)this.desensitizationConvertEnum, (Object)DesensitizationConvertEnum.DESENSITIZATION) ? desensitizationProcessor.desensitize(field.getName(), oldValue) : desensitizationProcessor.revert(field.getName(), oldValue);
                field.set(o, newValue);
            }
            catch (Exception e) {
                errorMessage.append(e.getMessage());
            }
        }
        if (errorMessage.length() <= 0) return o;
        throw new DatabaseEncryptException(errorMessage.toString());
    }
}

