/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.desensitization.processor;

import com.digiwin.dap.middle.database.encrypt.annotation.DesensitizationStrategy;
import com.digiwin.dap.middle.database.encrypt.desensitization.processor.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DesensitizationStrategy(mode=DesensitizationModeEnum.AES)
public class AESDesensitizationProcessor
implements DesensitizationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESDesensitizationProcessor.class);

    @Override
    public String desensitize(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        try {
            AES.decryptHex((String)value, (String)KeyConstant.DIGIWIN);
            LOGGER.info("===>{}\u5b57\u6bb5\u5df2\u7ecfAES\u52a0\u5bc6,\u5bc6\u6587:{}", (Object)field, (Object)value);
            return value;
        }
        catch (Exception e) {
            try {
                return AES.encryptHex((String)value, (String)KeyConstant.DIGIWIN);
            }
            catch (Exception e2) {
                LOGGER.error("===>{}\u5b57\u6bb5\u5df2\u7ecfAES\u52a0\u5bc6\u5f02\u5e38,\u503c:{}", (Object)field, (Object)value);
                return value;
            }
        }
    }

    @Override
    public String revert(String field, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        try {
            return AES.decryptHex((String)value, (String)KeyConstant.DIGIWIN);
        }
        catch (Exception e) {
            LOGGER.error("===>{}\u5b57\u6bb5\u5df2\u7ecfAES\u89e3\u5bc6\u5f02\u5e38,\u503c:{}", (Object)field, (Object)value);
            return value;
        }
    }
}

