package com.digiwin.dap.middle.database.encrypt.model;

import com.digiwin.dap.middle.database.encrypt.desensitization.checker.Checker;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;

/**
 * @author michael
 */
public class SensitiveWordProperty {

    private final String tableName;

    private final String dataBaseColumnName;

    private final String entityPropertyName;

    private final DesensitizationModeEnum desensitizationModeEnum;

    private final Class<? extends Checker> checkerClass;

    public SensitiveWordProperty(String tableName, String dataBaseColumnName, String entityPropertyName, DesensitizationModeEnum desensitizationModeEnum, Class<? extends Checker> checkerClass) {
        this.tableName = tableName;
        this.dataBaseColumnName = dataBaseColumnName;
        this.entityPropertyName = entityPropertyName;
        this.desensitizationModeEnum = desensitizationModeEnum;
        this.checkerClass = checkerClass;
    }

    public String getTableName() {
        return tableName;
    }

    public String getDataBaseColumnName() {
        return dataBaseColumnName;
    }

    public String getEntityPropertyName() {
        return entityPropertyName;
    }

    public DesensitizationModeEnum getDesensitizationModeEnum() {
        return desensitizationModeEnum;
    }

    public Class<? extends Checker> getCheckerClass() {
        return checkerClass;
    }
}
