package com.digiwin.dap.middle.database.encrypt.enums;

public enum DatabaseEncryptExceptionEnum {

    FOUND_MULTIPLE_SENSITIVE_WORD_PROPERTY(10000,"根据属性名称找到多个敏感策略"),
    TRAVERSE_OBJECT(10001,"遍历object对象处理脱敏失败"),
    FIELD_ALREADY_AES_ENCRYPTED(10002,"当前字段s%值s%已经aes加密"),
    FIELD_AES_DECRYPTED_FAIL(10003,"当前字段s%值s%aes解密失败"),
    DESENSITIZATION_FAIL(10004,"%s方法参数脱敏失败"),
    REVERT_FAIL(10005,"%s方法返回结果还原失败"),
    NOT_FOUND_PROCESSOR(10006,"未找到%相关的processor"),
    PARSE_SQL(10007,"sql解析异常")
    ;

    private final int code;

    private final String message;

    DatabaseEncryptExceptionEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
