/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.api;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.domain.DictDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.domain.StdData;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/${spring.application.name}/v2/dict"})
public class DictController {
    @Autowired
    private DictService dictService;

    @PostMapping(value={"/add"})
    public StdData<Integer> saveDict(@RequestBody DictDTO dto) {
        Assert.hasText((String)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.dictService.insertDict((Dict)((Object)dto.doForward())));
    }

    @PostMapping(value={"/mod"})
    public StdData<Integer> updateDict(@RequestBody DictDTO dto) {
        Assert.notNull((Object)dto.getSid(), (String)"sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.dictService.updateDict((Dict)((Object)dto.doForward())));
    }

    @PostMapping(value={"/del"})
    public StdData<Integer> deleteDict(@RequestBody DictDTO dto) {
        Assert.notNull((Object)dto.getSid(), (String)"\u5b57\u5178sid\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.dictService.deleteDictBySid(dto.getSid()));
    }

    @PostMapping(value={"/find"})
    public StdData<Dict> findDict(@RequestBody DictDTO dto) {
        Assert.isTrue((dto.getSid() != null || StrUtils.isNotEmpty((String)dto.getId()) ? 1 : 0) != 0, (String)"\u5b57\u5178sid\u3001id\u4e0d\u80fd\u5168\u4e3a\u7a7a");
        return StdData.ok((Object)((Object)this.dictService.selectDict(dto)));
    }

    @PostMapping(value={"/exists"})
    public StdData<Boolean> existsDict(@RequestBody DictDTO dto) {
        Assert.hasText((String)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)Optional.ofNullable(this.dictService.selectDictById(dto.getId())).isPresent());
    }

    @PostMapping(value={"/search"})
    public StdData<PageSerializable<Dict>> searchDict(@RequestBody DictDTO dto) {
        return StdData.ok(this.dictService.selectDictList(dto, dto.getPageNum(), dto.getPageSize(), dto.getOrderBy()));
    }

    @PostMapping(value={"/list"})
    public StdData<List<Dict>> listDict(@RequestBody DictDTO dto) {
        return StdData.ok(this.dictService.selectDictList(dto));
    }
}

