/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.service.impl;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.mapper.DictDataMapper;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DictDataServiceImpl
implements DictDataService {
    @Autowired
    private DictDataMapper dictDataMapper;
    @Autowired
    private DictService dictService;

    @Override
    public DictData selectDictDataBySid(Long sid) {
        return this.dictDataMapper.selectDictData(new DictDataDTO(sid));
    }

    @Override
    public DictData selectDictData(DictDataDTO dto) {
        return this.dictDataMapper.selectDictData(dto);
    }

    @Override
    public List<DictData> selectDictDataList(DictDataDTO dto) {
        return this.dictDataMapper.selectDictDataList(Optional.ofNullable(dto).orElse(new DictDataDTO()));
    }

    @Override
    public PageSerializable<DictData> selectDictDataList(DictDataDTO dto, Integer pageNum, Integer pageSize, String orderBy) {
        return PageSerializable.of(this.dictDataMapper.selectDictDataList(Optional.ofNullable(dto).orElse(new DictDataDTO()), pageNum, pageSize, Optional.ofNullable(orderBy).orElse("dd.dict_sort")));
    }

    @Override
    public int insertDictData(DictData dictData) {
        Dict dict = this.dictService.selectDictById(dictData.getDictId());
        Assert.notNull((Object)((Object)dict), (String)String.format("\u5b57\u5178[%s]\u4e0d\u5b58\u5728", dictData.getDictId()));
        DictData exists = this.dictDataMapper.selectDictData(new DictDataDTO(dictData.getDictId(), dictData.getDictKey()));
        Assert.isNull((Object)((Object)exists), (String)String.format("\u5b57\u5178[%s]key[%s]\u5df2\u5b58\u5728", dictData.getDictId(), dictData.getDictKey()));
        EntityUtils.setCreateFields((BaseEntity)dictData);
        dictData.setSid(SnowFlake.getInstance().newId());
        return this.dictDataMapper.insertDictData(dictData);
    }

    @Override
    public int updateDictData(DictData dictData) {
        Dict dict = this.dictService.selectDictById(dictData.getDictId());
        Assert.notNull((Object)((Object)dict), (String)String.format("\u5b57\u5178[%s]\u4e0d\u5b58\u5728", dictData.getDictId()));
        DictData exists = this.dictDataMapper.selectDictData(new DictDataDTO(dictData.getDictId(), dictData.getDictKey()));
        Assert.isTrue((exists == null || dictData.getSid() == exists.getSid() ? 1 : 0) != 0, (String)String.format("\u5b57\u5178[%s]key[%s]\u5df2\u5b58\u5728", dictData.getDictId(), dictData.getDictKey()));
        EntityUtils.setModifyFields((BaseEntity)dictData);
        return this.dictDataMapper.updateDictData(dictData);
    }

    @Override
    public int deleteDictDataBySids(Collection<Long> sids) {
        return this.dictDataMapper.deleteDictDataBySids(sids);
    }

    @Override
    public int deleteDictDataBySid(Long sid) {
        return this.dictDataMapper.deleteDictDataBySids(Collections.singletonList(sid));
    }
}

