CREATE TABLE `dict`
(
    `sid`             bigint      NOT NULL,
    `id`              varchar(40) NOT NULL COMMENT '字典id',
    `name`            varchar(128) DEFAULT NULL COMMENT '字典名称',
    `remark`          varchar(512) DEFAULT NULL COMMENT '说明描述',
    `create_by`       bigint       DEFAULT '0',
    `create_date`     datetime     DEFAULT NULL,
    `create_org`      bigint       DEFAULT '0',
    `create_provider` bigint       DEFAULT '0',
    `create_by_id`    varchar(255) DEFAULT NULL,
    `modify_by_id`    varchar(255) DEFAULT NULL,
    `hash`            varchar(40)  DEFAULT NULL,
    `modify_by`       bigint       DEFAULT '0',
    `modify_date`     datetime     DEFAULT NULL,
    `modify_provider` bigint       DEFAULT '0',
    `disabled`        bit(1)       DEFAULT b'0',
    `deleted`         bit(1)       DEFAULT b'0',
    PRIMARY KEY (`sid`),
    UNIQUE KEY `uk_id` (`id`)
) COMMENT ='字典类型表';

CREATE TABLE `dict_data`
(
    `sid`             bigint      NOT NULL,
    `dict_id`         varchar(40) NOT NULL COMMENT '字典id',
    `dict_key`        varchar(40) NOT NULL COMMENT '字典key',
    `dict_value`      varchar(128) DEFAULT NULL COMMENT '字典值',
    `dict_sort`       int          DEFAULT NULL COMMENT '字典排序',
    `remark`          varchar(512) DEFAULT NULL COMMENT '说明描述',
    `create_by`       bigint       DEFAULT '0',
    `create_date`     datetime     DEFAULT NULL,
    `create_org`      bigint       DEFAULT '0',
    `create_provider` bigint       DEFAULT '0',
    `create_by_id`    varchar(255) DEFAULT NULL,
    `modify_by_id`    varchar(255) DEFAULT NULL,
    `hash`            varchar(40)  DEFAULT NULL,
    `modify_by`       bigint       DEFAULT '0',
    `modify_date`     datetime     DEFAULT NULL,
    `modify_provider` bigint       DEFAULT '0',
    `disabled`        bit(1)       DEFAULT b'0',
    `deleted`         bit(1)       DEFAULT b'0',
    PRIMARY KEY (`sid`),
    UNIQUE KEY `uk_dict_id_dict_value` (`dict_id`, `dict_key`) USING BTREE
) COMMENT ='字典数据表';