package com.digiwin.dap.middle.encrypt;

import com.digiwin.dap.middle.encrypt.filter.EncryptRequestFilter;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middle.encrypt.support.DefaultDapSecretSupport;
import com.digiwin.dap.middleware.domain.DapEnv;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import javax.servlet.Filter;

/**
 * 加密加签starter
 *
 * @author ChenZhuang
 */
@Configuration
@ComponentScan("com.digiwin.dap.middle.encrypt")
public class EncryptAutoConfiguration {
    private static final String[] DEFAULT_URL_MAPPINGS = {"/api/*"};

    @Bean
    @ConditionalOnBean({DapEnv.class, RestTemplate.class})
    @ConditionalOnMissingBean(value = DapSecretSupport.class, search = SearchStrategy.CURRENT)
    public DapSecretSupport dapSecretSupport(DapEnv dapEnv, RestTemplate restTemplate) {
        return new DefaultDapSecretSupport(dapEnv, restTemplate);
    }

    @Bean
    @ConditionalOnBean(value = DapEnv.class)
    public FilterRegistrationBean<Filter> encryptRequestFilter(DapEnv dapEnv, DapSecretSupport dapSecretSupport) {
        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        final EncryptRequestFilter filter = new EncryptRequestFilter(dapEnv, dapSecretSupport);
        registrationBean.setFilter(filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}
