package com.digiwin.dap.middle.encrypt.config;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middle.encrypt.contstant.EncryptConstants;
import com.digiwin.dap.middle.encrypt.domain.StdDataEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 加密加签 响应处理
 * <p>
 * 根据验签、解密的标记，自动加密、加签
 *
 * @author ChenZhuang
 * @date 2024 -3-7 14:12:18
 */
@ControllerAdvice
public class EncryptResponse implements ResponseBodyAdvice<StdData> {
    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(DapEncrypt.class) || AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), DapEncrypt.class) != null
                || returnType.hasMethodAnnotation(DapSign.class) || AnnotationUtils.findAnnotation(returnType.getDeclaringClass(), DapSign.class) != null;
    }

    @Override
    public StdData<?> beforeBodyWrite(StdData body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        HttpServletRequest req = ((ServletServerHttpRequest) request).getServletRequest();
        if (Boolean.TRUE.equals(req.getAttribute(EncryptConstants.ENCRYPT_STATUS_KEY))) {
            String appSecret = (String) req.getAttribute(EncryptConstants.APP_SECRET_KEY);
            if (body.getData() != null) {
                String dataString;
                if (BeanUtils.isSimpleProperty(body.getData().getClass())) {
                    dataString = body.getData().toString();
                } else {
                    dataString = JsonUtils.objToJson(body.getData());
                }
                String eData = SecureUtils.encryptBase64(dataString, appSecret);
                body.setData(eData);
            }
        }

        if (Boolean.TRUE.equals(req.getAttribute(EncryptConstants.SIGN_STATUS_KEY))) {
            StdDataEncrypt<Object> dataEncrypt = new StdDataEncrypt<>();
            dataEncrypt.setCode(body.getCode());
            dataEncrypt.setMessage(body.getMessage());
            dataEncrypt.setSuccess(body.isSuccess());
            dataEncrypt.setData(body.getData());

            String appSecret = (String) req.getAttribute(EncryptConstants.APP_SECRET_KEY);
            String dataString;
            if (BeanUtils.isSimpleProperty(body.getData().getClass())) {
                dataString = body.getData().toString();
            } else {
                Map<String, String> beanMap = JsonUtils.objToMap(body.getData());
                dataString = MapUtil.sortJoin(beanMap, EncryptConstants.AND, EncryptConstants.EQUALS_SIGN, true);
            }
            String sign = SecureUtil.hmacSha256(appSecret).digestBase64(dataString, CharsetUtil.CHARSET_UTF_8, true);
            dataEncrypt.setSign(sign);
            body = dataEncrypt;
        }
        return body;
    }
}