package com.digiwin.dap.middle.encrypt.service;

import com.digiwin.dap.middle.encrypt.domain.DapEncryptDTO;
import com.digiwin.dap.middle.encrypt.domain.DapSignInfo;

import java.util.HashMap;

public interface EncryptService {
    DapEncryptDTO encrypt(String token,String appToken, Object data);


    DapSignInfo sign(String token,String appToken, Object data, HashMap<String,String> requestParam);


    /**
     * 获取解密对象
     *
     * <p>
     * 1.验签 2.解密
     * </p>
     *
     * @param dto        the dto
     * @param targetType 解密后对象Class
     * @return the 解密对象
     */
    <T> T getDecryptData(DapEncryptDTO<T> dto, Class<T> targetType);

}
