package com.digiwin.dap.middle.encrypt.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.digiwin.dap.middle.encrypt.contstant.EncryptConstants;
import com.digiwin.dap.middle.encrypt.domain.DapEncryptDTO;
import com.digiwin.dap.middle.encrypt.domain.DapSignInfo;
import com.digiwin.dap.middle.encrypt.service.EncryptService;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middle.encrypt.util.EncryptUtil;
import com.digiwin.dap.middle.encrypt.util.WebUtil;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class EncryptServiceImpl implements EncryptService {

    @Resource
    private DapSecretSupport dapSecretSupport;

    @Override
    public DapEncryptDTO  encrypt(String token,String appToken, Object data) {
        String appSecret = dapSecretSupport.getAppSecret(token, appToken);
        return EncryptUtil.encrypt(appSecret, data);
    }

    @Override
    public DapSignInfo sign(String token,String appToken, Object data, HashMap<String,String> requestParam) {
        DapSignInfo signInfo = new DapSignInfo();
        signInfo.setTimestamp(LocalDateTimeUtil.format(LocalDateTime.now(), DatePattern.PURE_DATETIME_FORMATTER));
        signInfo.setNonce(RandomUtil.randomString(16));
        // 1.sign header
        Map<String, String> signInfoMap = JsonUtils.objToMap(signInfo);
        String signHeaderParams = MapUtil.sortJoin(signInfoMap, "&", "=", true);
        //2.query param
        String requestParams=null;
        if(!CollectionUtils.isEmpty(requestParam)){
            requestParams=MapUtil.sortJoin(requestParam,"&","=",true);
        }
        //3.body
        String appSecret = dapSecretSupport.getAppSecret(token, appToken);
        DapEncryptDTO dto = EncryptUtil.encrypt(appSecret,data);
        String beanParams = MapUtil.sortJoin(JsonUtils.objToMap(dto), "&", "=", true);
        //组合所有类型的数据
        List<String> signList= ListUtil.toList(signHeaderParams,requestParams,beanParams);
        CollUtil.removeEmpty(signList);
        String signString=CollUtil.join(signList,"&");
        String sign = SecureUtil.hmacSha256(appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        signInfo.setSign(sign);
        return signInfo;
    }



    @Override
    public <T> T getDecryptData(DapEncryptDTO<T> dto, Class<T> targetType) {
        // 已验签，此处只做解密
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            throw new BusinessException("获取请求request为空");
        }
        String appSecret = (String) request.getAttribute(EncryptConstants.APP_SECRET_KEY);
        if (ObjectUtils.isEmpty(appSecret)) {
            appSecret = dapSecretSupport.getAppSecret(UserUtils.getToken(),request.getHeader(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY));
            if (ObjectUtils.isEmpty(appSecret)) {
                throw new BusinessException(StrUtil.format("应用[{}] appSecret为空，请联系管理员设置", UserUtils.getSysId()));
            }
            request.setAttribute(EncryptConstants.APP_SECRET_KEY, appSecret);
        }

        T  result= EncryptUtil.getDecryptData(appSecret,dto,targetType);
        request.setAttribute(EncryptConstants.ENCRYPT_STATUS_KEY, true);
        return result;
    }
}
