package com.digiwin.dap.middle.encrypt.util;

import com.digiwin.dap.middleware.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

public class AesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AesUtil.class);
    private static final int ivSize = 16;

    /**
     * 加密
     *
     * <p>
     * 模式： "AES/CBC/PKCS5Padding"
     * <p>
     * 说明：
     *  <ul>
     *     <li>1.CBC引入了初始向量比ECB模式更安全，块之间有关联性，同明文不同上下文，密文不相同</li>
     *     <li>2.使用 16 位随机数组作为 IV 初始向量，随机码数组拼接在密文的前16位，同明文的密文每次都会变化</li>
     *     <li>3.加密后转为base64字符串，比Hex更少的字符，更适用于网络传输</li>
     *     <li>4.对不规范长度的密钥key自动补位</li>
     * </ul>
     *
     * @param content 明文
     * @param key     AES密钥长度128位(支持A128/192/256)，密钥会自动补全16字符串(128位)
     * @return Base64 string
     */
    public static String encryptBase64(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

            byte[] iv = new byte[ivSize];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);

            SecretKeySpec secretKeySpec = new SecretKeySpec(fillKey(key), "AES");
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivParams);

            byte[] encryptedText = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] ivAndEncryptedText = new byte[ivSize + encryptedText.length];

            System.arraycopy(iv, 0, ivAndEncryptedText, 0, ivSize);
            System.arraycopy(encryptedText, 0, ivAndEncryptedText, ivSize, encryptedText.length);
            return new String(org.apache.commons.codec.binary.Base64.encodeBase64(ivAndEncryptedText));
        } catch (Exception e) {
            throw new BusinessException("加密异常，aes content=" + content, e);
        }
    }

    public static String decryptBase64(String content, String key) {
        try {
            byte[] ivAndEncryptedText = org.apache.commons.codec.binary.Base64.decodeBase64(content.getBytes());

            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivAndEncryptedText, 0, ivSize);

            SecretKeySpec secretKeySpec = new SecretKeySpec(fillKey(key), "AES");
            cipher.init(Cipher.DECRYPT_MODE, secretKeySpec, ivParameterSpec);

            byte[] contentBytes = cipher.doFinal(ivAndEncryptedText, ivSize, ivAndEncryptedText.length - ivSize);
            return new String(contentBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new BusinessException("解密异常，aes content=" + content, e);
        }
    }

    public static byte[] fillKey(String key) {
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            finalKey[i++ % 16] ^= b;
        }
        return finalKey;
    }
}
