package com.digiwin.dap.middle.encrypt.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middle.encrypt.contstant.EncryptConstants;
import com.digiwin.dap.middle.encrypt.domain.DapEncryptDTO;
import com.digiwin.dap.middle.encrypt.domain.DapSignInfo;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EncryptUtil {
    public static DapEncryptDTO encrypt(String appSecret, Object data){
        if (ObjectUtils.isEmpty(appSecret)) {
            throw new BusinessException("appSecret不能为空");
        }
        String body = JsonUtils.objToJson(data);
        String eData = SecureUtils.encryptBase64(body, appSecret);
        DapEncryptDTO dto = new DapEncryptDTO();
        dto.seteData(eData);
        return dto;
    }

    public static DapSignInfo signByEncryptBody(String appSecret, DapEncryptDTO data, HashMap<String,String> requestParam){
        DapSignInfo signInfo = new DapSignInfo();
        signInfo.setTimestamp(LocalDateTimeUtil.format(LocalDateTime.now(), DatePattern.PURE_DATETIME_FORMATTER));
        signInfo.setNonce(RandomUtil.randomString(16));
        // 1.sign header
        Map<String, String> signInfoMap = JsonUtils.objToMap(signInfo);
        String signHeaderParams = MapUtil.sortJoin(signInfoMap, "&", "=", true);
        //2.query param
        String requestParams=null;
        if(!CollectionUtils.isEmpty(requestParam)){
            requestParams=MapUtil.sortJoin(requestParam,"&","=",true);
        }
        String beanParams = MapUtil.sortJoin(JsonUtils.objToMap(data), "&", "=", true);
        //组合所有类型的数据
        List<String> signList= ListUtil.toList(signHeaderParams,requestParams,beanParams);
        CollUtil.removeEmpty(signList);
        String signString=CollUtil.join(signList,"&");
        String sign = SecureUtil.hmacSha256(appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        signInfo.setSign(sign);
        return signInfo;
    }

    public static <T> T getDecryptData(String appSecret,DapEncryptDTO<T> dto, Class<T> targetType){
        // 解密
        if (ObjectUtils.isEmpty(dto.geteData())) {
            throw new BusinessException("密文eData不能为空");
        }
        String data = SecureUtils.decryptBase64(dto.geteData(), appSecret);
        return JsonUtils.jsonToObj(data, targetType);
    }
}
