/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt;

import com.digiwin.dap.middle.encrypt.filter.EncryptRequestFilter;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middle.encrypt.support.DefaultDapSecretSupport;
import com.digiwin.dap.middleware.domain.DapEnv;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ComponentScan(value={"com.digiwin.dap.middle.encrypt"})
public class EncryptAutoConfiguration {
    private static final String[] DEFAULT_URL_MAPPINGS = new String[]{"/api/*"};

    @Bean
    @ConditionalOnBean(value={DapEnv.class, RestTemplate.class})
    @ConditionalOnMissingBean(value={DapSecretSupport.class}, search=SearchStrategy.CURRENT)
    public DapSecretSupport dapSecretSupport(DapEnv dapEnv, RestTemplate restTemplate) {
        return new DefaultDapSecretSupport(dapEnv, restTemplate);
    }

    @Bean
    @ConditionalOnBean(value={DapEnv.class})
    public FilterRegistrationBean<Filter> encryptRequestFilter(DapEnv dapEnv, DapSecretSupport dapSecretSupport) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        EncryptRequestFilter filter = new EncryptRequestFilter(dapEnv, dapSecretSupport);
        registrationBean.setFilter((Filter)filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}

