/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.config;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middle.encrypt.domain.StdDataEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponse
implements ResponseBodyAdvice<StdData> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(DapEncrypt.class) || AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), DapEncrypt.class) != null || returnType.hasMethodAnnotation(DapSign.class) || AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), DapSign.class) != null;
    }

    public StdData<?> beforeBodyWrite(StdData body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        HttpServletRequest req = ((ServletServerHttpRequest)request).getServletRequest();
        if (Boolean.TRUE.equals(req.getAttribute("encryptStatus"))) {
            String appSecret = (String)req.getAttribute("appSecret");
            if (body.getData() != null) {
                String dataString = BeanUtils.isSimpleProperty(body.getData().getClass()) ? body.getData().toString() : JsonUtils.objToJson((Object)body.getData());
                String eData = SecureUtils.encryptBase64((String)dataString, (String)appSecret);
                body.setData(eData);
            }
        }
        if (Boolean.TRUE.equals(req.getAttribute("signStatus"))) {
            String dataString;
            StdDataEncrypt dataEncrypt = new StdDataEncrypt();
            dataEncrypt.setCode(body.getCode());
            dataEncrypt.setMessage(body.getMessage());
            dataEncrypt.setSuccess(body.isSuccess());
            dataEncrypt.setData(body.getData());
            String appSecret = (String)req.getAttribute("appSecret");
            if (BeanUtils.isSimpleProperty(body.getData().getClass())) {
                dataString = body.getData().toString();
            } else {
                Map beanMap = JsonUtils.objToMap((Object)body.getData());
                dataString = MapUtil.sortJoin((Map)beanMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
            }
            String sign = SecureUtil.hmacSha256((String)appSecret).digestBase64(dataString, CharsetUtil.CHARSET_UTF_8, true);
            dataEncrypt.setSign(sign);
            body = dataEncrypt;
        }
        return body;
    }
}

