/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.domain;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.StringJoiner;
import org.springframework.util.ObjectUtils;

public class DapSignInfo {
    private String nonce;
    private String timestamp;
    private String sign;

    public static DapSignInfo get(String json) {
        try {
            String decode = URLDecoder.decode(json, StandardCharsets.UTF_8.name());
            return (DapSignInfo)JsonUtils.createObjectMapper().readValue(decode, DapSignInfo.class);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_HEADER_ARG_PARSING_FAILED, new Object[]{json});
        }
    }

    public static void verify(DapSignInfo o) {
        if (o == null) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_HEADER_ARG_EMPTY);
        }
        if (ObjectUtils.isEmpty((Object)o.getNonce())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_NONCE_EMPTY);
        }
        if (o.getNonce().length() < 10 || o.getNonce().length() > 40) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_NONCE_LENGTH_ERROR, new Object[]{o.getNonce()});
        }
        if (ObjectUtils.isEmpty((Object)o.getTimestamp())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_TIMESTAMP_EMPTY);
        }
        try {
            LocalDateTime localDateTime = LocalDateTimeUtil.parse((CharSequence)o.getTimestamp(), (String)"yyyyMMddHHmmss");
        }
        catch (DateTimeParseException e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_TIMESTAMP_FORMAT_ERROR, new Object[]{o.getTimestamp()});
        }
        if (ObjectUtils.isEmpty((Object)o.getSign())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGNATURE_SIGN_EMPTY);
        }
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String toString() {
        return new StringJoiner(", ", DapSignInfo.class.getSimpleName() + "[", "]").add("nonce='" + this.nonce + "'").add("timestamp='" + this.timestamp + "'").add("sign='" + this.sign + "'").toString();
    }
}

