/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.digiwin.dap.middle.encrypt.config.EncryptRequestWrapper;
import com.digiwin.dap.middle.encrypt.domain.DapEncryptDTO;
import com.digiwin.dap.middle.encrypt.domain.DapSignInfo;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class EncryptRequestFilter
extends OncePerRequestFilter
implements Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptRequestFilter.class);
    private static final List<String> bodyMethodList = Arrays.asList(RequestMethod.POST.name(), RequestMethod.PUT.name());
    private final DapEnv dapEnv;
    private final DapSecretSupport dapSecretSupport;

    public EncryptRequestFilter(DapEnv dapEnv, DapSecretSupport dapSecretSupport) {
        this.dapEnv = dapEnv;
        this.dapSecretSupport = dapSecretSupport;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HandlerExecutionChain handlerChain = EncryptRequestFilter.getHandlerExecutionChain(request);
        if (handlerChain == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handlerChain.getHandler();
        Method method = handlerMethod.getMethod();
        DapSign dapSign = EncryptRequestFilter.getDapSign(handlerMethod);
        DapEncrypt dapEncrypt = EncryptRequestFilter.getDapEncrypt(handlerMethod);
        String signHeader = request.getHeader("digi-middleware-sign-arg");
        boolean sign = this.isSign(dapSign, signHeader);
        EncryptRequestWrapper encryptRequestWrapper = new EncryptRequestWrapper(request);
        String bodyString = encryptRequestWrapper.getBodyString();
        boolean encrypt = this.isEncrypt(request, dapEncrypt, bodyString);
        if (!sign && !encrypt) {
            filterChain.doFilter((ServletRequest)encryptRequestWrapper, (ServletResponse)response);
            return;
        }
        AuthoredSys authoredSys = UserUtils.getAuthoredSys();
        if (authoredSys == null || ObjectUtils.isEmpty((Object)authoredSys.getId())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.APP_ID_NONE);
        }
        String appToken = request.getHeader(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY);
        String appSecret = this.dapSecretSupport.getAppSecret(UserUtils.getToken(), appToken);
        if (ObjectUtils.isEmpty((Object)appSecret)) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.APP_ID_SECRET_NONE, new Object[]{UserUtils.getSysId()});
        }
        if (sign) {
            this.sign(request, appSecret, signHeader, bodyString, method);
        }
        if (encrypt) {
            String data = EncryptRequestFilter.decrypt(request, bodyString, appSecret);
            encryptRequestWrapper.setBodyString(data.getBytes(StandardCharsets.UTF_8));
        }
        filterChain.doFilter((ServletRequest)encryptRequestWrapper, (ServletResponse)response);
    }

    public int getOrder() {
        return FilterOrderEnum.API_ENCRYPT.order();
    }

    private static DapEncrypt getDapEncrypt(HandlerMethod handlerMethod) {
        DapEncrypt dapEncrypt = (DapEncrypt)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), DapEncrypt.class);
        if (dapEncrypt == null) {
            dapEncrypt = (DapEncrypt)handlerMethod.getMethodAnnotation(DapEncrypt.class);
        }
        return dapEncrypt;
    }

    private static DapSign getDapSign(HandlerMethod handlerMethod) {
        DapSign dapSign = (DapSign)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), DapSign.class);
        if (dapSign == null) {
            dapSign = (DapSign)handlerMethod.getMethodAnnotation(DapSign.class);
        }
        return dapSign;
    }

    private boolean isSign(DapSign dapSign, String signHeader) {
        if (dapSign == null) {
            return false;
        }
        return dapSign.force() || Boolean.TRUE.equals(this.dapEnv.getSign()) || !ObjectUtils.isEmpty((Object)signHeader);
    }

    private boolean isEncrypt(HttpServletRequest request, DapEncrypt dapEncrypt, String bodyString) {
        if (!bodyMethodList.contains(request.getMethod()) || dapEncrypt == null) {
            return false;
        }
        if (!dapEncrypt.force() && !Boolean.TRUE.equals(this.dapEnv.getEncrypt())) {
            DapEncryptDTO dto;
            if (ObjectUtils.isEmpty((Object)bodyString)) {
                throw new BusinessException((ErrorHandler)CommonErrorCode.ENCRYPT_REQUEST_BODY_EMPTY);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bf7\u6c42\u53c2\u6570body\uff1a{}", (Object)bodyString);
            }
            return (dto = (DapEncryptDTO)JsonUtils.readValue((String)bodyString, DapEncryptDTO.class)) != null && !ObjectUtils.isEmpty((Object)dto.geteData());
        }
        return true;
    }

    private static String decrypt(HttpServletRequest request, String bodyString, String appSecret) {
        DapEncryptDTO dto = (DapEncryptDTO)JsonUtils.readValue((String)bodyString, DapEncryptDTO.class);
        String data = SecureUtils.decryptBase64((String)dto.geteData(), (String)appSecret);
        request.setAttribute("encryptStatus", (Object)true);
        request.setAttribute("appSecret", (Object)appSecret);
        return data;
    }

    private void sign(HttpServletRequest request, String appSecret, String signHeader, String bodyString, Method method) {
        String parsed = new String(signHeader.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        DapSignInfo signInfo = DapSignInfo.get(parsed);
        DapSignInfo.verify(signInfo);
        LocalDateTime dateTime = LocalDateTimeUtil.parse((CharSequence)signInfo.getTimestamp(), (String)"yyyyMMddHHmmss");
        if (Math.abs(System.currentTimeMillis() - LocalDateTimeUtil.toEpochMilli((TemporalAccessor)dateTime)) > 300000L) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_TIMESTAMP_EXPIRED, new Object[]{signInfo.getTimestamp()});
        }
        String key = this.getKey(signInfo.getNonce());
        boolean absent = RedisUtils.setIfAbsent((String)key, (Object)1, (Duration)Duration.ofMillis(600000L));
        if (!absent) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_DUPLICATE_REQUEST_ERROR, new Object[]{signInfo.getNonce()});
        }
        String requestParams = null;
        String beanParams = null;
        Map signInfoMap = JsonUtils.objToMap((Object)signInfo);
        signInfoMap.remove("sign");
        String signHeaderParams = MapUtil.sortJoin((Map)signInfoMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        Map paramMap = ServletUtil.getParamMap((ServletRequest)request);
        if (!paramMap.isEmpty()) {
            requestParams = MapUtil.sortJoin((Map)paramMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        }
        if (!ObjectUtils.isEmpty((Object)bodyString)) {
            block0: for (int i = 0; i < method.getParameterCount(); ++i) {
                Annotation[] parameterAnnotations;
                MethodParameter mp = new MethodParameter(method, i);
                for (Annotation anno : parameterAnnotations = mp.getParameterAnnotations()) {
                    if (!(anno instanceof RequestBody) && !(anno instanceof ModelAttribute)) continue;
                    Class type = mp.getParameterType();
                    if (BeanUtils.isSimpleProperty((Class)type)) {
                        beanParams = bodyString;
                        break block0;
                    }
                    Map beanMap = (Map)JsonUtils.jsonToObj((String)bodyString, Map.class);
                    beanParams = MapUtil.sortJoin((Map)beanMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
                    break block0;
                }
            }
        }
        LinkedList linkedList = ListUtil.toLinkedList((Object[])new String[]{signHeaderParams, requestParams, beanParams});
        CollUtil.removeEmpty((Collection)linkedList);
        String signString = CollUtil.join((Iterable)linkedList, (CharSequence)"&");
        String encryptSign = SecureUtil.hmacSha256((String)appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        if (!Objects.equals(encryptSign, signInfo.getSign())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.SIGN_INCONSISTENT_SIGNATURES_ERROR, new Object[]{encryptSign});
        }
        request.setAttribute("signStatus", (Object)true);
        request.setAttribute("appSecret", (Object)appSecret);
    }

    private String getKey(String nonce) {
        String appName = ObjectUtils.isEmpty((Object)this.dapEnv.getAppName()) ? "middleware" : this.dapEnv.getAppName().toLowerCase();
        return String.format("%s:sign:nonce:%s", appName, nonce);
    }

    private static HandlerExecutionChain getHandlerExecutionChain(HttpServletRequest request) {
        HandlerExecutionChain handlerChain;
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        String mappingName = Introspector.decapitalize(RequestMappingHandlerMapping.class.getSimpleName());
        RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(mappingName, RequestMappingHandlerMapping.class);
        try {
            handlerChain = handlerMapping.getHandler(request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return handlerChain;
    }
}

