/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middle.encrypt.domain.DapEncryptDTO;
import com.digiwin.dap.middle.encrypt.domain.DapSignInfo;
import com.digiwin.dap.middle.encrypt.service.EncryptService;
import com.digiwin.dap.middle.encrypt.support.DapSecretSupport;
import com.digiwin.dap.middle.encrypt.util.EncryptUtil;
import com.digiwin.dap.middle.encrypt.util.WebUtil;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class EncryptServiceImpl
implements EncryptService {
    @Resource
    private DapSecretSupport dapSecretSupport;

    @Override
    public DapEncryptDTO encrypt(String token, String appToken, Object data) {
        String appSecret = this.dapSecretSupport.getAppSecret(token, appToken);
        return EncryptUtil.encrypt(appSecret, data);
    }

    @Override
    public DapSignInfo sign(String token, String appToken, Object data, HashMap<String, String> requestParam) {
        DapSignInfo signInfo = new DapSignInfo();
        signInfo.setTimestamp(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.PURE_DATETIME_FORMATTER));
        signInfo.setNonce(RandomUtil.randomString((int)16));
        Map signInfoMap = JsonUtils.objToMap((Object)signInfo);
        String signHeaderParams = MapUtil.sortJoin((Map)signInfoMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        String requestParams = null;
        if (!CollectionUtils.isEmpty(requestParam)) {
            requestParams = MapUtil.sortJoin(requestParam, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        }
        String appSecret = this.dapSecretSupport.getAppSecret(token, appToken);
        DapEncryptDTO dto = EncryptUtil.encrypt(appSecret, data);
        String beanParams = MapUtil.sortJoin((Map)JsonUtils.objToMap((Object)dto), (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        ArrayList signList = ListUtil.toList((Object[])new String[]{signHeaderParams, requestParams, beanParams});
        CollUtil.removeEmpty((Collection)signList);
        String signString = CollUtil.join((Iterable)signList, (CharSequence)"&");
        String sign = SecureUtil.hmacSha256((String)appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        signInfo.setSign(sign);
        return signInfo;
    }

    @Override
    public <T> T getDecryptData(DapEncryptDTO<T> dto, Class<T> targetType) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            throw new BusinessException("\u83b7\u53d6\u8bf7\u6c42request\u4e3a\u7a7a");
        }
        String appSecret = (String)request.getAttribute("appSecret");
        if (ObjectUtils.isEmpty((Object)appSecret)) {
            appSecret = this.dapSecretSupport.getAppSecret(UserUtils.getToken(), request.getHeader(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY));
            if (ObjectUtils.isEmpty((Object)appSecret)) {
                throw new BusinessException(StrUtil.format((CharSequence)"\u5e94\u7528[{}] appSecret\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e", (Object[])new Object[]{UserUtils.getSysId()}));
            }
            request.setAttribute("appSecret", (Object)appSecret);
        }
        T result = EncryptUtil.getDecryptData(appSecret, dto, targetType);
        request.setAttribute("encryptStatus", (Object)true);
        return result;
    }
}

