/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.util;

import com.digiwin.dap.middleware.exception.BusinessException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AesUtil.class);
    private static final int ivSize = 16;

    public static String encryptBase64(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            SecretKeySpec secretKeySpec = new SecretKeySpec(AesUtil.fillKey(key), "AES");
            cipher.init(1, (Key)secretKeySpec, ivParams);
            byte[] encryptedText = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] ivAndEncryptedText = new byte[16 + encryptedText.length];
            System.arraycopy(iv, 0, ivAndEncryptedText, 0, 16);
            System.arraycopy(encryptedText, 0, ivAndEncryptedText, 16, encryptedText.length);
            return new String(Base64.encodeBase64((byte[])ivAndEncryptedText));
        }
        catch (Exception e) {
            throw new BusinessException("\u52a0\u5bc6\u5f02\u5e38\uff0caes content=" + content, (Throwable)e);
        }
    }

    public static String decryptBase64(String content, String key) {
        try {
            byte[] ivAndEncryptedText = Base64.decodeBase64((byte[])content.getBytes());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivAndEncryptedText, 0, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(AesUtil.fillKey(key), "AES");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] contentBytes = cipher.doFinal(ivAndEncryptedText, 16, ivAndEncryptedText.length - 16);
            return new String(contentBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u5bc6\u5f02\u5e38\uff0caes content=" + content, (Throwable)e);
        }
    }

    public static byte[] fillKey(String key) {
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            int n = i++ % 16;
            finalKey[n] = (byte)(finalKey[n] ^ b);
        }
        return finalKey;
    }
}

