/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middle.encrypt.domain.DapEncryptDTO;
import com.digiwin.dap.middle.encrypt.domain.DapSignInfo;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class EncryptUtil {
    public static DapEncryptDTO encrypt(String appSecret, Object data) {
        if (ObjectUtils.isEmpty((Object)appSecret)) {
            throw new BusinessException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String body = JsonUtils.objToJson((Object)data);
        String eData = SecureUtils.encryptBase64((String)body, (String)appSecret);
        DapEncryptDTO dto = new DapEncryptDTO();
        dto.seteData(eData);
        return dto;
    }

    public static DapSignInfo signByEncryptBody(String appSecret, DapEncryptDTO data, HashMap<String, String> requestParam) {
        DapSignInfo signInfo = new DapSignInfo();
        signInfo.setTimestamp(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.PURE_DATETIME_FORMATTER));
        signInfo.setNonce(RandomUtil.randomString((int)16));
        Map signInfoMap = JsonUtils.objToMap((Object)signInfo);
        String signHeaderParams = MapUtil.sortJoin((Map)signInfoMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        String requestParams = null;
        if (!CollectionUtils.isEmpty(requestParam)) {
            requestParams = MapUtil.sortJoin(requestParam, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        }
        String beanParams = MapUtil.sortJoin((Map)JsonUtils.objToMap((Object)data), (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        ArrayList signList = ListUtil.toList((Object[])new String[]{signHeaderParams, requestParams, beanParams});
        CollUtil.removeEmpty((Collection)signList);
        String signString = CollUtil.join((Iterable)signList, (CharSequence)"&");
        String sign = SecureUtil.hmacSha256((String)appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        signInfo.setSign(sign);
        return signInfo;
    }

    public static <T> T getDecryptData(String appSecret, DapEncryptDTO<T> dto, Class<T> targetType) {
        if (ObjectUtils.isEmpty((Object)dto.geteData())) {
            throw new BusinessException("\u5bc6\u6587eData\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String data = SecureUtils.decryptBase64((String)dto.geteData(), (String)appSecret);
        return (T)JsonUtils.jsonToObj((String)data, targetType);
    }
}

