package com.digiwin.dap.middle.encrypt.domain.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 接口加密注解
 *
 * @author ChenZhuang
 * @date 2024-01-09 18:14:11
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface DapEncrypt {

    /**
     * 强制加密
     *
     * @return the boolean
     */
    boolean force() default true;

    /**
     * 返回值是否加密
     * <p>
     * 默认请求加密，返回就加密；设置false时，响应不再加密。
     *
     * @return the boolean
     */
    boolean responseEncrypt() default true;
}
