package com.digiwin.dap.middle.encrypt.domain.annotation;

import java.lang.annotation.*;

/**
 *  接口签名注解
 *
 * @author ChenZhuang
 * @date 2024-01-09 18:14:20
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DapSign {

    /**
     * 强制验签
     *
     * @return the boolean
     */
    boolean force() default true;

    /**
     * 允许重复请求
     * <p>
     * 考虑：是否有get请求有重试机制，允许重试
     *
     * @return the boolean
     */
    boolean resubmit() default false;

    /**
     * 返回值是否加签
     * <p>
     * 默认请求加签，返回就加签；设置false时，响应不再加签。
     *
     * @return the boolean
     */
    boolean responseSign() default true;
}